/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.creativeTab;

import com.toukun.mymod.block.ModBlocks;
import com.toukun.mymod.item.ModItems;
import com.toukun.mymod.item.classes.CustomTabPopulator;
import com.toukun.mymod.item.creativeTab.ToukunCreativeTab;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class CreativeTabs {
    private static void registerToukunTab(BuildCreativeModeTabContentsEvent event) {
        ModItems.ITEMS.getEntries().forEach(itemRegistryObject -> {
            Item item = (Item)itemRegistryObject.get();
            if (item instanceof CustomTabPopulator) {
                CustomTabPopulator customTabPopulator = (CustomTabPopulator)item;
                customTabPopulator.populateItemCategory(event);
            } else {
                event.accept((ItemLike)item);
            }
        });
    }

    private static void registerBuildingBlocks(BuildCreativeModeTabContentsEvent event) {
        event.accept((ItemLike)ModBlocks.CHISELED_SMOOTH_STONE_BLOCK.asItem());
        event.accept((ItemLike)ModBlocks.SILVER_BLOCK.asItem());
    }

    private static void registerNaturalBlocks(BuildCreativeModeTabContentsEvent event) {
        event.accept((ItemLike)ModBlocks.SILVER_ORE.asItem());
        event.accept((ItemLike)ModBlocks.RAW_SILVER_BLOCK.asItem());
    }

    private static void registerFunctionalBlocks(BuildCreativeModeTabContentsEvent event) {
        event.accept((ItemLike)ModBlocks.STONE_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.SOUL_STONE_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.COPPER_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.SOUL_COPPER_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.IRON_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.SOUL_IRON_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.GOLD_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.SOUL_GOLD_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.SILVER_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.SOUL_SILVER_WALL_SCONCE.asItem());
        event.accept((ItemLike)ModBlocks.PORTAL_BLOCK.asItem());
    }

    private static void registerToolsAndUtilities(BuildCreativeModeTabContentsEvent event) {
        event.accept((ItemLike)ModItems.PORTAL_STONE.get());
        event.accept((ItemLike)Items.BUNDLE);
        event.accept((ItemLike)ModItems.SHULKER_BUNDLE.get());
    }

    private static void registerCombat(BuildCreativeModeTabContentsEvent event) {
        event.accept((ItemLike)ModItems.WOODEN_BATTLE_AXE.get());
        event.accept((ItemLike)ModItems.STONE_BATTLE_AXE.get());
        event.accept((ItemLike)ModItems.IRON_BATTLE_AXE.get());
        event.accept((ItemLike)ModItems.GOLDEN_BATTLE_AXE.get());
        event.accept((ItemLike)ModItems.DIAMOND_BATTLE_AXE.get());
        event.accept((ItemLike)ModItems.NETHERITE_BATTLE_AXE.get());
        event.accept((ItemLike)ModItems.WOODEN_BLADE.get());
        event.accept((ItemLike)ModItems.STONE_BLADE.get());
        event.accept((ItemLike)ModItems.IRON_BLADE.get());
        event.accept((ItemLike)ModItems.GOLDEN_BLADE.get());
        event.accept((ItemLike)ModItems.DIAMOND_BLADE.get());
        event.accept((ItemLike)ModItems.NETHERITE_BLADE.get());
        event.accept((ItemLike)ModItems.WOODEN_KATANA.get());
        event.accept((ItemLike)ModItems.STONE_KATANA.get());
        event.accept((ItemLike)ModItems.IRON_KATANA.get());
        event.accept((ItemLike)ModItems.GOLDEN_KATANA.get());
        event.accept((ItemLike)ModItems.DIAMOND_KATANA.get());
        event.accept((ItemLike)ModItems.NETHERITE_KATANA.get());
        event.accept((ItemLike)ModItems.WOODEN_MAGE_STAFF.get());
        event.accept((ItemLike)ModItems.STONE_MAGE_STAFF.get());
        event.accept((ItemLike)ModItems.IRON_MAGE_STAFF.get());
        event.accept((ItemLike)ModItems.GOLDEN_MAGE_STAFF.get());
        event.accept((ItemLike)ModItems.DIAMOND_MAGE_STAFF.get());
        event.accept((ItemLike)ModItems.NETHERITE_MAGE_STAFF.get());
        event.accept((ItemLike)ModItems.WOODEN_SPEAR.get());
        event.accept((ItemLike)ModItems.STONE_SPEAR.get());
        event.accept((ItemLike)ModItems.IRON_SPEAR.get());
        event.accept((ItemLike)ModItems.GOLDEN_SPEAR.get());
        event.accept((ItemLike)ModItems.DIAMOND_SPEAR.get());
        event.accept((ItemLike)ModItems.NETHERITE_SPEAR.get());
        event.accept((ItemLike)ModItems.WOODEN_WAR_HAMMER.get());
        event.accept((ItemLike)ModItems.STONE_WAR_HAMMER.get());
        event.accept((ItemLike)ModItems.IRON_WAR_HAMMER.get());
        event.accept((ItemLike)ModItems.GOLDEN_WAR_HAMMER.get());
        event.accept((ItemLike)ModItems.DIAMOND_WAR_HAMMER.get());
        event.accept((ItemLike)ModItems.NETHERITE_WAR_HAMMER.get());
        event.accept((ItemLike)ModItems.FLINT_THROWING_KNIFE.get());
        event.accept((ItemLike)ModItems.IRON_THROWING_KNIFE.get());
        event.accept((ItemLike)ModItems.OBSIDIAN_THROWING_KNIFE.get());
        event.accept((ItemLike)ModItems.NETHERITE_CHAINMAIL_HELMET.get());
        event.accept((ItemLike)ModItems.NETHERITE_CHAINMAIL_CHESTPLATE.get());
        event.accept((ItemLike)ModItems.NETHERITE_CHAINMAIL_LEGGINGS.get());
        event.accept((ItemLike)ModItems.NETHERITE_CHAINMAIL_BOOTS.get());
    }

    private static void registerFoodAndDrinks(BuildCreativeModeTabContentsEvent event) {
        event.accept((ItemLike)ModItems.BEEF_STEW.get());
    }

    private static void registerIngredients(BuildCreativeModeTabContentsEvent event) {
        event.accept((ItemLike)ModItems.RAW_SILVER.get());
        event.accept((ItemLike)ModItems.SILVER_NUGGET.get());
        event.accept((ItemLike)ModItems.SILVER_INGOT.get());
        event.accept((ItemLike)ModItems.CHAIN_SHEET.get());
    }

    public static void registerItems(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        CreativeModeTab currentTab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(tabKey);
        if (currentTab == ToukunCreativeTab.TOUKUN_TAB.get()) {
            CreativeTabs.registerToukunTab(event);
        }
        if (tabKey == CreativeModeTabs.BUILDING_BLOCKS) {
            CreativeTabs.registerBuildingBlocks(event);
        }
        if (tabKey == CreativeModeTabs.NATURAL_BLOCKS) {
            CreativeTabs.registerNaturalBlocks(event);
        }
        if (tabKey == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            CreativeTabs.registerFunctionalBlocks(event);
        }
        if (tabKey == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            CreativeTabs.registerToolsAndUtilities(event);
        }
        if (tabKey == CreativeModeTabs.COMBAT) {
            CreativeTabs.registerCombat(event);
        }
        if (tabKey == CreativeModeTabs.FOOD_AND_DRINKS) {
            CreativeTabs.registerFoodAndDrinks(event);
        }
        if (tabKey == CreativeModeTabs.INGREDIENTS) {
            CreativeTabs.registerIngredients(event);
        }
    }
}

