/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.custom;

import com.toukun.mymod.item.classes.CooldownItem;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FriendRadarItem
extends CooldownItem {
    private static final String NO_PLAYERS = "item.toukun.friend_radar.no_players";
    private static final String[] DESCRIPTIONS = new String[]{"item.toukun.friend_radar.description"};
    private static final TargetingConditions TARGETING = TargetingConditions.forNonCombat().range(128.0);

    public FriendRadarItem(Item.Properties properties, int cooldown) {
        super(properties, cooldown);
        this.toolTipBuilder.addDescription(DESCRIPTIONS);
    }

    private static MobEffectInstance getEffect() {
        return new MobEffectInstance(MobEffects.GLOWING, 400, 1, false, false, true);
    }

    @Override
    protected void onUseServer(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
        List players = level.getNearbyPlayers(TARGETING, (LivingEntity)player, player.getBoundingBox().inflate(128.0));
        if (players.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)NO_PLAYERS));
        }
        for (Player targetedPlayers : players) {
            targetedPlayers.addEffect(FriendRadarItem.getEffect());
        }
        player.addEffect(FriendRadarItem.getEffect());
    }

    @Override
    protected void onUseClient(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
    }
}

