/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.custom;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.toukun.mymod.block.ModBlocks;
import com.toukun.mymod.item.ModItems;
import com.toukun.mymod.item.classes.CooldownItem;
import com.toukun.mymod.utility.PortalUtils;
import com.toukun.mymod.utility.ToolTipBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PortalStoneItem
extends CooldownItem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DESCRIPTION = "item.toukun.portal_stone.description";
    private static final String ATTUNED_DESCRIPTION_ID = "item.toukun.attuned_portal_stone";
    private static final String ATTUNED_DESCRIPTION = "item.toukun.attuned_portal_stone.description";
    private static final String PORTAL_DIMENSION_TAG = "PortalDimension";
    private static final String PORTAL_COORDINATES_TAG = "PortalPosition";
    private static final String NO_ATTUNED_MESSAGE = "item.toukun.portal_stone.not_attuned";
    private static final String NO_PORTAL_MESSAGE = "item.toukun.attuned_portal_stone.destroyed";
    private static final int COOLDOWN = 12000;

    public PortalStoneItem(Item.Properties properties) {
        super(properties, 12000);
    }

    public static boolean isAttunedPortalStone(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.getTag();
        return compoundTag != null && compoundTag.contains(PORTAL_DIMENSION_TAG) && compoundTag.contains(PORTAL_COORDINATES_TAG);
    }

    private static Optional<ResourceKey<Level>> getPortalDimension(CompoundTag compoundTag) {
        return Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(PORTAL_DIMENSION_TAG)).result();
    }

    @Nullable
    public static GlobalPos getPortalPosition(CompoundTag compoundTag) {
        Optional<ResourceKey<Level>> optionalLevelResourceKey;
        if (compoundTag.contains(PORTAL_DIMENSION_TAG) && compoundTag.contains(PORTAL_COORDINATES_TAG) && (optionalLevelResourceKey = PortalStoneItem.getPortalDimension(compoundTag)).isPresent()) {
            BlockPos blockPos = NbtUtils.readBlockPos((CompoundTag)compoundTag.getCompound(PORTAL_COORDINATES_TAG));
            return GlobalPos.of(optionalLevelResourceKey.get(), (BlockPos)blockPos);
        }
        return null;
    }

    public boolean isFoil(ItemStack itemStack) {
        return PortalStoneItem.isAttunedPortalStone(itemStack) || super.isFoil(itemStack);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (PortalStoneItem.isAttunedPortalStone(itemStack)) {
            this.toolTipBuilder.build(components);
            components.add(ToolTipBuilder.getNewLineComponent());
            components.add((Component)Component.translatable((String)ATTUNED_DESCRIPTION));
        } else {
            components.add(ToolTipBuilder.getNewLineComponent());
            components.add((Component)Component.translatable((String)DESCRIPTION));
        }
    }

    @Override
    protected void onUseServer(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
        BlockState blockState;
        ServerLevel serverLevel;
        if (!PortalStoneItem.isAttunedPortalStone(itemStack)) {
            player.sendSystemMessage((Component)Component.translatable((String)NO_ATTUNED_MESSAGE));
            return;
        }
        GlobalPos portalPosition = PortalStoneItem.getPortalPosition(itemStack.getOrCreateTag());
        if (portalPosition == null) {
            LOGGER.error("Unable to find Global Position");
            return;
        }
        MinecraftServer server = player.getServer();
        if (server == null) {
            LOGGER.error("Server somehow null.");
        }
        if ((serverLevel = server.getLevel(portalPosition.dimension())) == null) {
            LOGGER.error("ServerLevel is somehow null.");
        }
        if ((blockState = serverLevel.getBlockState(portalPosition.pos())).getBlock() != ModBlocks.PORTAL_BLOCK.get()) {
            player.sendSystemMessage((Component)Component.translatable((String)NO_PORTAL_MESSAGE));
            return;
        }
        double x = portalPosition.pos().getX();
        double y = portalPosition.pos().getY();
        double z = portalPosition.pos().getZ();
        float angle = ((ServerPlayer)player).getRespawnAngle();
        Optional<Vec3> findRespawnPositionOpt = PortalUtils.FindPortalExitPosition(EntityType.PLAYER, (CollisionGetter)serverLevel, portalPosition.pos());
        if (findRespawnPositionOpt.isPresent()) {
            Vec3 finalRespawnPosition = findRespawnPositionOpt.get();
            x = finalRespawnPosition.x;
            y = finalRespawnPosition.y;
            z = finalRespawnPosition.z;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)x, (int)y, (int)z));
        serverLevel.getChunkSource().addRegionTicket(TicketType.PLAYER, chunkPos, 1, (Object)player.chunkPosition());
        if (!player.isCreative()) {
            player.getCooldowns().addCooldown((Item)this, 12000);
        }
        if (serverLevel == player.level()) {
            player.teleportTo(x, y, z);
        } else {
            ((ServerPlayer)player).teleportTo(serverLevel, x, y, z, angle, angle);
        }
        serverLevel.playSound(null, x, y, z, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    protected void onUseClient(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
    }

    public InteractionResult useOn(UseOnContext context) {
        boolean shouldAdjustItem;
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        if (!level.getBlockState(blockpos).is((Block)ModBlocks.PORTAL_BLOCK.get())) {
            return super.useOn(context);
        }
        level.playSound(null, blockpos, SoundEvents.AMETHYST_BLOCK_STEP, SoundSource.PLAYERS, 1.0f, 1.0f);
        Player player = context.getPlayer();
        ItemStack itemstack = context.getItemInHand();
        boolean bl = shouldAdjustItem = player != null && !player.getAbilities().instabuild && itemstack.getCount() == 1;
        if (shouldAdjustItem) {
            this.addPortalTags((ResourceKey<Level>)level.dimension(), blockpos, itemstack.getOrCreateTag());
        } else {
            ItemStack newItemStack = new ItemStack((ItemLike)ModItems.PORTAL_STONE.get(), 1);
            CompoundTag compoundtag = itemstack.hasTag() ? itemstack.getTag().copy() : new CompoundTag();
            newItemStack.setTag(compoundtag);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.addPortalTags((ResourceKey<Level>)level.dimension(), blockpos, compoundtag);
            if (!player.getInventory().add(newItemStack)) {
                player.drop(newItemStack, false);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private void addPortalTags(ResourceKey<Level> levelResourceKey, BlockPos blockPos, CompoundTag compoundTag) {
        compoundTag.put(PORTAL_COORDINATES_TAG, (Tag)NbtUtils.writeBlockPos((BlockPos)blockPos));
        Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, levelResourceKey).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put(PORTAL_DIMENSION_TAG, tag));
    }

    public String getDescriptionId(ItemStack itemStack) {
        return PortalStoneItem.isAttunedPortalStone(itemStack) ? ATTUNED_DESCRIPTION_ID : super.getDescriptionId(itemStack);
    }
}

