/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.custom;

import com.toukun.mymod.entity.classes.AbstractDamageProjectile;
import com.toukun.mymod.entity.classes.Projectile;
import com.toukun.mymod.item.classes.staves.DamagingStaffItem;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ProjectileStaffItem
extends DamagingStaffItem {
    private static final String[] DESCRIPTIONS = new String[]{"item.toukun.projectile_staff.description"};
    private final Projectile projectile;

    public ProjectileStaffItem(Tier tier, Item.Properties properties, Projectile projectile) {
        super(tier, properties, projectile.getUseTime(), projectile.getDurabilityCost(), (float)projectile.getBaseDamage() + tier.getAttackDamageBonus());
        this.projectile = projectile;
        this.toolTipBuilder.addDescription(DESCRIPTIONS);
    }

    @Override
    protected void onUseServer(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
        Vec3 direction = player.getForward();
        AbstractDamageProjectile projectile = this.projectile.getProjectile(level, (LivingEntity)player, direction.x, direction.y, direction.z);
        projectile.setPos(projectile.getX() + direction.x, player.getY(0.7), projectile.getZ() + direction.z);
        projectile.setDamage(this.getSpellDamage(itemStack));
        level.addFreshEntity((Entity)projectile);
    }

    @Override
    protected void onUseClient(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
        level.playSound(null, (Entity)player, this.projectile.getCastSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

