/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.custom;

import com.toukun.mymod.entity.custom.SunlightSpearEntity;
import com.toukun.mymod.item.classes.CastingItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class SunlightSpearItem
extends CastingItem {
    private static final int COOLDOWN = 600;
    private static final int USE_TIME = 20;

    public SunlightSpearItem(Item.Properties properties) {
        super(properties, 600, 20);
        this.toolTipBuilder.addDamage(20.0f);
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    @Override
    protected void onUseServer(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
        SunlightSpearEntity sunlightSpearEntity = new SunlightSpearEntity(level, (LivingEntity)player);
        sunlightSpearEntity.setItem(itemStack);
        sunlightSpearEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 4.0f, 1.0f);
        level.addFreshEntity((Entity)sunlightSpearEntity);
    }

    @Override
    protected void onUseClient(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
        level.playSound(null, (Entity)player, SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.PLAYERS, 0.5f, 1.0f);
    }
}

