/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.custom;

import com.toukun.mymod.entity.custom.ThrowingKnifeEntity;
import com.toukun.mymod.utility.ToolTipBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ThrowingKnifeItem
extends Item {
    private static final int cooldown = 10;
    private static final String DESCRIPTION = "item.toukun.throwing_knife.description";
    private final int damage;
    private final ToolTipBuilder toolTipBuilder;

    public ThrowingKnifeItem(Item.Properties properties, int damage) {
        super(properties);
        this.damage = damage;
        this.toolTipBuilder = new ToolTipBuilder().addDamage(damage).addDescription(new String[]{DESCRIPTION});
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level l, List<Component> components, TooltipFlag flag) {
        this.toolTipBuilder.build(components);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrowingKnifeEntity throwingKnife = new ThrowingKnifeEntity(level, (LivingEntity)player);
            throwingKnife.setDamage(this.damage);
            throwingKnife.setItem(itemStack);
            throwingKnife.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)throwingKnife);
            if (!player.isCreative()) {
                player.getCooldowns().addCooldown((Item)this, 10);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
    }
}

