/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.network;

import com.toukun.mymod.network.client.DashCooldownHandler;
import com.toukun.mymod.network.client.HearthCooldownHandler;
import com.toukun.mymod.network.client.OpenMenuHandler;
import com.toukun.mymod.network.client.PartyEndClientHandler;
import com.toukun.mymod.network.client.PartyInviteClientHandler;
import com.toukun.mymod.network.client.PartyTeleportClientHandler;
import com.toukun.mymod.network.client.PartyUpdateClientHandler;
import com.toukun.mymod.network.configuration.DashTask;
import com.toukun.mymod.network.configuration.HearthTask;
import com.toukun.mymod.network.configuration.OpenMenuTask;
import com.toukun.mymod.network.configuration.PartyEndTask;
import com.toukun.mymod.network.configuration.PartyInviteTask;
import com.toukun.mymod.network.configuration.PartyTeleportTask;
import com.toukun.mymod.network.configuration.PartyUpdateTask;
import com.toukun.mymod.network.packets.DashPacket;
import com.toukun.mymod.network.packets.HearthPacket;
import com.toukun.mymod.network.packets.OpenMenuPacket;
import com.toukun.mymod.network.packets.PartyEndPacket;
import com.toukun.mymod.network.packets.PartyInvitePacket;
import com.toukun.mymod.network.packets.PartyTeleportPacket;
import com.toukun.mymod.network.packets.PartyUpdatePacket;
import com.toukun.mymod.network.server.DashPressedHandler;
import com.toukun.mymod.network.server.HearthPressedHandler;
import com.toukun.mymod.network.server.OpenMenuPressedHandler;
import com.toukun.mymod.network.server.PartyEndServerHandler;
import com.toukun.mymod.network.server.PartyInviteServerHandler;
import com.toukun.mymod.network.server.PartyTeleportServerHandler;
import com.toukun.mymod.network.server.PartyUpdateServerHandler;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.event.OnGameConfigurationEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class ModNetworking {
    private static final String PROTOCOL_VERSION = "1.0.0";

    public static void registerPayload(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("toukun").versioned(PROTOCOL_VERSION);
        registrar.play(DashPacket.ID, DashPacket::new, handler -> handler.client(DashCooldownHandler.getInstance()::handleData).server(DashPressedHandler.getInstance()::handleData));
        registrar.play(HearthPacket.ID, HearthPacket::new, handler -> handler.client(HearthCooldownHandler.getInstance()::handleData).server(HearthPressedHandler.getInstance()::handleData));
        registrar.play(OpenMenuPacket.ID, OpenMenuPacket::new, handler -> handler.client(OpenMenuHandler.getInstance()::handleData).server(OpenMenuPressedHandler.getInstance()::handleData));
        registrar.play(PartyInvitePacket.ID, PartyInvitePacket::new, handler -> handler.client(PartyInviteClientHandler.getInstance()::handleData).server(PartyInviteServerHandler.getInstance()::handleData));
        registrar.play(PartyUpdatePacket.ID, PartyUpdatePacket::new, handler -> handler.client(PartyUpdateClientHandler.getInstance()::handleData).server(PartyUpdateServerHandler.getInstance()::handleData));
        registrar.play(PartyEndPacket.ID, PartyEndPacket::new, handler -> handler.client(PartyEndClientHandler.getInstance()::handleData).server(PartyEndServerHandler.getInstance()::handleData));
        registrar.play(PartyTeleportPacket.ID, PartyTeleportPacket::new, handler -> handler.client(PartyTeleportClientHandler.getInstance()::handleData).server(PartyTeleportServerHandler.getInstance()::handleData));
    }

    public static void registerConfig(OnGameConfigurationEvent event) {
        event.register((ICustomConfigurationTask)new DashTask(event.getListener()));
        event.register((ICustomConfigurationTask)new HearthTask(event.getListener()));
        event.register((ICustomConfigurationTask)new OpenMenuTask(event.getListener()));
        event.register((ICustomConfigurationTask)new PartyInviteTask(event.getListener()));
        event.register((ICustomConfigurationTask)new PartyUpdateTask(event.getListener()));
        event.register((ICustomConfigurationTask)new PartyEndTask(event.getListener()));
        event.register((ICustomConfigurationTask)new PartyTeleportTask(event.getListener()));
    }
}

