/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.network.server;

import com.toukun.mymod.advancements.ModCriteriaTriggers;
import com.toukun.mymod.advancements.criteria.DashTrigger;
import com.toukun.mymod.attachments.dash.DashArmorUtils;
import com.toukun.mymod.attachments.dash.DashAttachmentHandler;
import com.toukun.mymod.network.NetworkErrorHandler;
import com.toukun.mymod.network.packets.DashPacket;
import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class DashPressedHandler {
    private static final DashPressedHandler INSTANCE = new DashPressedHandler();
    private static final double DASH_STRENGTH = 1.5;

    public static DashPressedHandler getInstance() {
        return INSTANCE;
    }

    private void processInput(ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (!player.isAlive() || player.isSleeping() || !player.onGround()) {
            return;
        }
        int dash = DashAttachmentHandler.GetDashCooldown(player);
        if (dash != 0) {
            return;
        }
        DashAttachmentHandler.ResetDashCooldown(player);
        int newCooldown = DashAttachmentHandler.GetDashCooldown(player);
        Vec3 direction = player.getForward().multiply(1.5, 0.0, 1.5).normalize();
        player.setDeltaMovement(direction.x, DashArmorUtils.GetDashHeight(player), direction.z);
        player.connection.send((Packet)new ClientboundSetEntityMotionPacket(player.getId(), player.getDeltaMovement()));
        ((DashTrigger)((Object)ModCriteriaTriggers.DASH_TRIGGER.get())).trigger(player, newCooldown);
        player.connection.send((CustomPacketPayload)new DashPacket(newCooldown));
    }

    public void handleData(DashPacket data, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Object patt2180$temp;
            Optional opt = context.player();
            if (opt.isPresent() && (patt2180$temp = opt.get()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt2180$temp;
                this.processInput(player);
            }
        }).exceptionally(e -> {
            NetworkErrorHandler.SendErrorMessage(context, e);
            return null;
        });
    }
}

