/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.network.server;

import com.toukun.mymod.advancements.ModCriteriaTriggers;
import com.toukun.mymod.advancements.criteria.HearthTrigger;
import com.toukun.mymod.attachments.hearth.HearthAttachmentHandler;
import com.toukun.mymod.network.NetworkErrorHandler;
import com.toukun.mymod.network.packets.HearthPacket;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class HearthPressedHandler {
    private static final HearthPressedHandler INSTANCE = new HearthPressedHandler();
    private static final String NO_HOME_SET = "message.toukun.no_home_set";

    public static HearthPressedHandler getInstance() {
        return INSTANCE;
    }

    private void processInput(ServerPlayer player) {
        Optional finalRespawnPositionOpt;
        if (player == null) {
            return;
        }
        if (!player.isAlive() || player.isSleeping()) {
            return;
        }
        int hearthCooldown = HearthAttachmentHandler.GetHearthCooldown(player);
        if (hearthCooldown != 0) {
            return;
        }
        ServerLevel serverLevel = player.server.getLevel(Level.OVERWORLD);
        BlockPos respawnPosition = player.getRespawnPosition();
        if (serverLevel == null || respawnPosition == null) {
            player.sendSystemMessage((Component)Component.translatable((String)NO_HOME_SET));
            return;
        }
        if (!serverLevel.isNaturalSpawningAllowed(respawnPosition)) {
            player.sendSystemMessage((Component)Component.translatable((String)NO_HOME_SET));
            return;
        }
        BlockState respawnBlockState = serverLevel.getBlockState(respawnPosition);
        Block block = respawnBlockState.getBlock();
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 20, 1, false, false));
        double x = respawnPosition.getX();
        double y = (double)respawnPosition.getY() + 0.2;
        double z = respawnPosition.getZ();
        float angle = player.getRespawnAngle();
        if (block instanceof BedBlock && BedBlock.canSetSpawn((Level)serverLevel) && (finalRespawnPositionOpt = BedBlock.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)serverLevel, (BlockPos)respawnPosition, (Direction)((Direction)respawnBlockState.getValue((Property)BedBlock.FACING)), (float)angle)).isPresent()) {
            Vec3 finalRespawnPosition = (Vec3)finalRespawnPositionOpt.get();
            x = finalRespawnPosition.x;
            y = finalRespawnPosition.y;
            z = finalRespawnPosition.z;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)x, (int)y, (int)z));
        serverLevel.getChunkSource().addRegionTicket(TicketType.PLAYER, chunkPos, 1, (Object)player.chunkPosition());
        HearthAttachmentHandler.ResetHearth(player);
        ((HearthTrigger)((Object)ModCriteriaTriggers.HEARTH_TRIGGER.get())).trigger(player);
        if (serverLevel == player.level()) {
            player.teleportTo(x, y, z);
        } else {
            player.teleportTo(serverLevel, x, y, z, angle, angle);
        }
        player.connection.send((CustomPacketPayload)new HearthPacket(HearthAttachmentHandler.GetHearthCooldown(player)));
    }

    public void handleData(HearthPacket data, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Object patt4183$temp;
            Optional opt = context.player();
            if (opt.isPresent() && (patt4183$temp = opt.get()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt4183$temp;
                this.processInput(player);
            }
        }).exceptionally(e -> {
            NetworkErrorHandler.SendErrorMessage(context, e);
            return null;
        });
    }
}

