/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.party;

import com.toukun.mymod.attachments.party.PartyTeleportAttachmentHelper;
import com.toukun.mymod.network.packets.PartyEndPacket;
import com.toukun.mymod.network.packets.PartyInvitePacket;
import com.toukun.mymod.network.packets.PartyTeleportPacket;
import com.toukun.mymod.network.packets.PartyUpdatePacket;
import com.toukun.mymod.party.exceptions.LeadershipTransferFailedException;
import com.toukun.mymod.party.exceptions.MemberNotLeaderException;
import com.toukun.mymod.party.exceptions.PartyNotFoundException;
import com.toukun.mymod.party.network.PartyUpdateData;
import com.toukun.mymod.party.serialization.Party;
import com.toukun.mymod.party.serialization.PartySavedData;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;

public class PartySystem {
    private final MinecraftServer server;
    private final Scoreboard scoreboard;
    private final PartySavedData data;
    private final boolean sendToChat;

    public PartySystem(MinecraftServer server) {
        this(server, false);
    }

    public PartySystem(MinecraftServer server, boolean sendToChat) {
        this.server = server;
        this.scoreboard = server.getScoreboard();
        this.data = PartySavedData.getPartySavedData(server.overworld());
        this.sendToChat = sendToChat;
    }

    private Set<UUID> createPlayerFilter(ServerPlayer player) {
        return this.createPlayerFilter(player.getUUID());
    }

    private Set<UUID> createPlayerFilter(UUID id) {
        return new HashSet<UUID>(Collections.singleton(id));
    }

    public void changePartyName(ServerPlayer player, String name) {
        Party party;
        try {
            party = this.getPartyAsLeader(player);
        }
        catch (MemberNotLeaderException | PartyNotFoundException e) {
            return;
        }
        party.setPartyName(name);
        this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.rename.success", (Object[])new Object[]{name}));
        this.sendEmptyUpdate(party);
    }

    public Party getPartyById(UUID partyId) throws PartyNotFoundException {
        Optional<Party> opt = this.data.findPartyByID(partyId);
        if (opt.isEmpty()) {
            throw new PartyNotFoundException();
        }
        return opt.get();
    }

    public Party getPartyByMember(ServerPlayer player, boolean disableCall) throws PartyNotFoundException {
        Optional<Party> opt = this.data.findFirstByMember(player.getUUID());
        if (opt.isEmpty()) {
            if (!disableCall) {
                this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_found"));
            }
            throw new PartyNotFoundException();
        }
        return opt.get();
    }

    public Party getPartyByMember(ServerPlayer player) throws PartyNotFoundException {
        return this.getPartyByMember(player, false);
    }

    public boolean partOfParty(ServerPlayer player) {
        return this.data.findFirstByMember(player.getUUID()).isPresent();
    }

    public Party getPartyAsLeader(ServerPlayer player, boolean disableCalls) throws PartyNotFoundException, MemberNotLeaderException {
        UUID playerId = player.getUUID();
        Optional<Party> opt = this.data.findFirstByMember(playerId);
        if (opt.isEmpty()) {
            if (!disableCalls) {
                this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_found"));
            }
            throw new PartyNotFoundException();
        }
        Party party = opt.get();
        if (!party.isLeader(playerId)) {
            if (!disableCalls) {
                this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_leader"));
            }
            throw new MemberNotLeaderException();
        }
        return opt.get();
    }

    public Party getPartyAsLeader(ServerPlayer player) throws PartyNotFoundException, MemberNotLeaderException {
        return this.getPartyAsLeader(player, false);
    }

    public void createParty(ServerPlayer player) {
        if (this.partOfParty(player)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.already_in"));
            return;
        }
        Party party = this.data.createParty(player.getUUID(), player.getName().getString());
        PlayerTeam team = this.scoreboard.addPlayerTeam(party.getPartyId().toString());
        this.scoreboard.addPlayerToTeam(player.getScoreboardName(), team);
        this.sendInit(player, party, true);
        team.setAllowFriendlyFire(false);
        team.setNameTagVisibility(Team.Visibility.HIDE_FOR_OTHER_TEAMS);
        team.setDisplayName((Component)Component.literal((String)party.getPartyName()));
        this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.create.success"));
    }

    public void disbandParty(ServerPlayer player) {
        Party party;
        try {
            party = this.getPartyAsLeader(player);
        }
        catch (MemberNotLeaderException | PartyNotFoundException e) {
            return;
        }
        this.sendDisband(party);
        UUID partyId = party.getPartyId();
        PlayerTeam team = this.scoreboard.getPlayerTeam(partyId.toString());
        if (team != null) {
            this.scoreboard.removePlayerTeam(team);
        }
        this.revokeOutstandingInvites(party);
        this.data.removeParty(partyId);
        this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.disband.success"));
    }

    public void leaveParty(ServerPlayer player) {
        boolean result;
        Party party;
        try {
            party = this.getPartyByMember(player);
        }
        catch (PartyNotFoundException e) {
            return;
        }
        try {
            result = party.removeMember(player.getUUID());
        }
        catch (LeadershipTransferFailedException e) {
            this.disbandParty(player);
            return;
        }
        if (!result) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.leave.failed"));
            return;
        }
        PlayerTeam team = this.scoreboard.getPlayerTeam(party.getPartyId().toString());
        if (team != null) {
            this.scoreboard.removePlayerFromTeam(player.getScoreboardName(), team);
        }
        this.sendLeft(player, party);
        this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.leave.success"));
        this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.leave.party_message", (Object[])new Object[]{player.getName()}));
    }

    public void invitePlayerToParty(ServerPlayer player, ServerPlayer target) {
        Party party;
        try {
            party = this.getPartyAsLeader(player);
        }
        catch (MemberNotLeaderException | PartyNotFoundException e) {
            return;
        }
        if (player.getUUID().equals(target.getUUID())) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.already_in"));
            return;
        }
        if (this.partOfParty(target)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.invite.already_in_party", (Object[])new Object[]{target.getName()}));
            return;
        }
        boolean result = party.inviteMember(target.getUUID());
        if (!result) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.invite.party_full"));
            return;
        }
        this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.invite.success", (Object[])new Object[]{target.getName()}));
        this.broadCastToSpecific(target, (Component)Component.translatable((String)"commands.party.invite.invite_message", (Object[])new Object[]{party.getPartyName(), player.getName()}));
        this.sendInvite(target, party);
    }

    public void removeMemberFromParty(ServerPlayer player, ServerPlayer target) {
        boolean result;
        Party party;
        if (player.getUUID().equals(target.getUUID())) {
            this.leaveParty(player);
            return;
        }
        try {
            party = this.getPartyAsLeader(player);
        }
        catch (MemberNotLeaderException | PartyNotFoundException e) {
            return;
        }
        if (!party.hasMember(target.getUUID())) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_same"));
            return;
        }
        try {
            result = party.removeMember(target.getUUID());
        }
        catch (LeadershipTransferFailedException e) {
            this.disbandParty(player);
            return;
        }
        if (!result) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.remove.failed"));
            return;
        }
        PlayerTeam team = this.scoreboard.getPlayerTeam(party.getPartyId().toString());
        if (team != null) {
            this.scoreboard.removePlayerFromTeam(target.getScoreboardName(), team);
        }
        this.sendRemoved(target, party);
        this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.leave.party_message", (Object[])new Object[]{target.getName()}));
        this.broadCastToSpecific(target, (Component)Component.translatable((String)"commands.party.remove.player", (Object[])new Object[]{party.getPartyName()}));
    }

    public void removeMemberFromParty(ServerPlayer player, UUID targetId, Party party) {
        if (!party.hasMember(targetId)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_same"));
            this.sendOfflineRemoved(targetId, party);
            return;
        }
        ServerPlayer removed = this.server.getPlayerList().getPlayer(targetId);
        if (removed == null) {
            String name = party.getMemberName(targetId);
            try {
                party.removeMember(targetId);
            }
            catch (LeadershipTransferFailedException e) {
                this.disbandParty(player);
                return;
            }
            this.sendOfflineRemoved(targetId, party);
            this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.leave.party_message", (Object[])new Object[]{name}));
            return;
        }
        this.removeMemberFromParty(player, removed);
    }

    public void promotePlayerToLeader(ServerPlayer player, ServerPlayer target) {
        Party party;
        UUID targetId = target.getUUID();
        if (player.getUUID().equals(targetId)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.promote.self"));
            return;
        }
        try {
            party = this.getPartyAsLeader(player);
        }
        catch (MemberNotLeaderException | PartyNotFoundException e) {
            return;
        }
        if (!party.hasMember(targetId)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_same"));
            return;
        }
        boolean result = party.changePartyLeader(targetId);
        if (!result) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_same"));
            return;
        }
        this.sendEmptyUpdate(party);
        this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.promote.success", (Object[])new Object[]{target.getName()}));
    }

    public void promotePlayerToLeader(ServerPlayer player, Party party, UUID targetId) {
        if (!party.hasMember(targetId)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_same"));
            this.sendOfflineRemoved(targetId, party);
            return;
        }
        ServerPlayer newLeader = this.server.getPlayerList().getPlayer(targetId);
        if (newLeader == null) {
            party.changePartyLeader(targetId);
            this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.promote.success", (Object[])new Object[]{party.getMemberName(targetId)}));
            return;
        }
        this.promotePlayerToLeader(player, newLeader);
    }

    public void joinParty(ServerPlayer player, ServerPlayer target) {
        Party party;
        if (this.partOfParty(player)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.already_in"));
            return;
        }
        try {
            party = this.getPartyByMember(target);
        }
        catch (PartyNotFoundException e) {
            return;
        }
        UUID playerId = player.getUUID();
        if (!party.isInvited(playerId)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.join.not_invited", (Object[])new Object[]{target.getName()}));
            return;
        }
        String playerName = player.getName().getString();
        boolean result = party.addMember(playerId, playerName);
        if (!result) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.invite.party_full"));
            return;
        }
        PlayerTeam team = this.scoreboard.getPlayerTeam(party.getPartyId().toString());
        if (team != null) {
            this.scoreboard.addPlayerToTeam(player.getScoreboardName(), team);
        }
        this.sendInit(player, party, true);
        this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.join.success", (Object[])new Object[]{party.getPartyName()}));
        this.sendUpdate(player);
        this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.join.party_message", (Object[])new Object[]{player.getName()}));
    }

    public void teleportToMember(ServerPlayer player, ServerPlayer target) {
        Party party;
        try {
            party = this.getPartyByMember(player);
        }
        catch (PartyNotFoundException e) {
            return;
        }
        int cooldown = PartyTeleportAttachmentHelper.GetPartyTeleportCooldown(player);
        if (cooldown > 0) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.teleport.not_ready", (Object[])new Object[]{PartyTeleportAttachmentHelper.CooldownInSeconds(cooldown)}));
            return;
        }
        if (!party.hasMember(target.getUUID())) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_same"));
            return;
        }
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 20, 1, false, false));
        ServerLevel targetLevel = target.serverLevel();
        if (targetLevel.getPlayerByUUID(player.getUUID()) != null) {
            player.teleportTo(target.getX(), target.getY(), target.getZ());
        } else {
            targetLevel.getChunkSource().addRegionTicket(TicketType.PLAYER, target.chunkPosition(), 1, (Object)player.chunkPosition());
            float angle = player.getRespawnAngle();
            player.teleportTo(targetLevel, target.getX(), target.getY(), target.getZ(), angle, angle);
        }
        PartyTeleportAttachmentHelper.ResetPartyTeleportCooldown(player);
    }

    public void receiveInvitePacket(PartyInvitePacket packet, ServerPlayer player) {
        Party party;
        UUID playerId = player.getUUID();
        UUID partyId = packet.partyId();
        try {
            party = this.getPartyById(partyId);
        }
        catch (PartyNotFoundException e) {
            player.connection.send((CustomPacketPayload)new PartyInvitePacket("", partyId, false));
            return;
        }
        if (!packet.status()) {
            party.removeInvite(player.getUUID());
            return;
        }
        String playerName = player.getName().getString();
        boolean result = party.addMember(playerId, playerName);
        if (!result) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.invite.party_full"));
            return;
        }
        PlayerTeam team = this.scoreboard.getPlayerTeam(party.getPartyId().toString());
        if (team != null) {
            this.scoreboard.addPlayerToTeam(player.getScoreboardName(), team);
        }
        this.sendInit(player, party, true);
        this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.join.success", (Object[])new Object[]{party.getPartyName()}));
        this.sendUpdate(player);
        this.broadcastToMembers(party, (Component)Component.translatable((String)"commands.party.join.party_message", (Object[])new Object[]{player.getName()}));
    }

    public void receiveUpdatePacket(PartyUpdatePacket packet, ServerPlayer player) {
        String dataName;
        UUID removed;
        Party party;
        PartyUpdateData data = packet.data();
        try {
            party = this.getPartyAsLeader(player);
        }
        catch (PartyNotFoundException e) {
            player.connection.send((CustomPacketPayload)new PartyEndPacket(true, true));
            return;
        }
        catch (MemberNotLeaderException e) {
            return;
        }
        UUID dataLeader = data.getLeaderId();
        if (!dataLeader.equals(player.getUUID())) {
            this.promotePlayerToLeader(player, party, dataLeader);
        }
        if ((removed = data.getRemovedPlayer()) != null) {
            if (player.getUUID().equals(removed)) {
                this.leaveParty(player);
            } else {
                this.removeMemberFromParty(player, removed, party);
            }
        }
        if (!(dataName = data.getPartyName()).equals(party.getPartyName())) {
            this.changePartyName(player, dataName);
        }
    }

    public void receiveTeleportPacket(PartyTeleportPacket packet, ServerPlayer player) {
        Party party;
        try {
            party = this.getPartyByMember(player);
        }
        catch (PartyNotFoundException e) {
            return;
        }
        if (PartyTeleportAttachmentHelper.GetPartyTeleportCooldown(player) > 0) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.teleport.not_ready"));
            return;
        }
        UUID targetId = packet.target();
        if (!party.hasMember(targetId)) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.not_same"));
            return;
        }
        ServerPlayer target = this.server.getPlayerList().getPlayer(targetId);
        if (target == null) {
            this.broadCastToSpecific(player, (Component)Component.translatable((String)"commands.party.teleport.not_online"));
            return;
        }
        this.teleportToMember(player, target);
    }

    public List<ServerPlayer> getPartyMembers(Party party) {
        return this.getPartyMembers(party, new HashSet<UUID>());
    }

    public List<ServerPlayer> getPartyMembers(Party party, Set<UUID> filter) {
        return this.server.getPlayerList().getPlayers().stream().filter(player -> party.hasMember(player.getUUID()) && !filter.contains(player.getUUID())).toList();
    }

    public void broadCastToSpecific(ServerPlayer player, Component component) {
        if (!this.sendToChat) {
            return;
        }
        player.sendSystemMessage(component);
    }

    public void broadcastToMembers(Party party, Component component) {
        if (!this.sendToChat) {
            return;
        }
        this.broadcastToMembers(party, component, new HashSet<UUID>());
    }

    public void broadcastToMembers(Party party, Component component, Set<UUID> filterSet) {
        if (!this.sendToChat) {
            return;
        }
        List<ServerPlayer> memberList = this.getPartyMembers(party, filterSet);
        if (memberList.isEmpty()) {
            return;
        }
        memberList.forEach(player -> this.broadCastToSpecific((ServerPlayer)player, component));
    }

    public void sendLoginInit(ServerPlayer player) {
        Party party;
        try {
            party = this.getPartyByMember(player, true);
        }
        catch (PartyNotFoundException e) {
            player.connection.send((CustomPacketPayload)new PartyEndPacket(true, true));
            return;
        }
        this.sendInit(player, party);
        this.sendUpdate(player);
    }

    public void sendInit(ServerPlayer player, Party party) {
        this.sendInit(player, party, false);
    }

    public void sendInit(ServerPlayer player, Party party, boolean newMember) {
        List<ServerPlayer> memberList = this.getPartyMembers(party);
        PartyUpdateData initData = PartyUpdateData.createInitData(party, memberList, newMember);
        player.connection.send((CustomPacketPayload)new PartyUpdatePacket(initData));
    }

    public void sendDisband(Party party) {
        PartyEndPacket partyEndPacket = new PartyEndPacket(false, true);
        this.getPartyMembers(party).forEach(player -> player.connection.send((CustomPacketPayload)partyEndPacket));
    }

    public void sendUpdate(ServerPlayer player) {
        this.sendUpdate(player, 0.0f);
    }

    public void sendUpdate(ServerPlayer player, float healthAdjust) {
        Party party;
        try {
            party = this.getPartyByMember(player, true);
        }
        catch (PartyNotFoundException e) {
            return;
        }
        this.sendUpdate(party, player, this.createPlayerFilter(player), healthAdjust);
    }

    public void sendUpdate(Party party, ServerPlayer player, Set<UUID> filter, float healthAdjust) {
        List<ServerPlayer> memberList = this.getPartyMembers(party, filter);
        PartyUpdateData data = PartyUpdateData.createUpdateData(party, player, healthAdjust);
        memberList.forEach(member -> member.connection.send((CustomPacketPayload)new PartyUpdatePacket(data)));
    }

    public void sendPlayerRemoved(ServerPlayer player, Party party, boolean forceful) {
        player.connection.send((CustomPacketPayload)new PartyEndPacket(forceful, false));
        List<ServerPlayer> memberList = this.getPartyMembers(party);
        PartyUpdateData data = PartyUpdateData.createRemovalData(party, player.getUUID());
        memberList.forEach(member -> member.connection.send((CustomPacketPayload)new PartyUpdatePacket(data)));
    }

    public void sendOfflineRemoved(UUID removedId, Party party) {
        List<ServerPlayer> memberList = this.getPartyMembers(party, new HashSet<UUID>(Collections.singleton(removedId)));
        PartyUpdateData data = PartyUpdateData.createRemovalData(party, removedId);
        memberList.forEach(member -> member.connection.send((CustomPacketPayload)new PartyUpdatePacket(data)));
    }

    public void sendLeft(ServerPlayer player, Party party) {
        this.sendPlayerRemoved(player, party, false);
    }

    public void sendRemoved(ServerPlayer player, Party party) {
        this.sendPlayerRemoved(player, party, true);
    }

    public void sendEmptyUpdate(Party party) {
        List<ServerPlayer> memberList = this.getPartyMembers(party);
        PartyUpdateData data = new PartyUpdateData(party);
        memberList.forEach(member -> member.connection.send((CustomPacketPayload)new PartyUpdatePacket(data)));
    }

    public void sendLogout(ServerPlayer player) {
        Party party;
        try {
            party = this.getPartyByMember(player, true);
        }
        catch (PartyNotFoundException e) {
            return;
        }
        PartyUpdateData data = PartyUpdateData.createLogoutData(party, player);
        List<ServerPlayer> memberList = this.getPartyMembers(party, new HashSet<UUID>(Collections.singleton(player.getUUID())));
        memberList.forEach(member -> member.connection.send((CustomPacketPayload)new PartyUpdatePacket(data)));
    }

    public void sendInvite(ServerPlayer player, Party party) {
        player.connection.send((CustomPacketPayload)new PartyInvitePacket(party.getPartyName(), party.getPartyId(), true));
    }

    public void revokeOutstandingInvites(Party party) {
        if (party.invitedCount() == 0) {
            return;
        }
        Set<UUID> invitedSet = party.getInvited();
        this.server.getPlayerList().getPlayers().stream().filter(player -> invitedSet.contains(player.getUUID())).forEach(player -> player.connection.send((CustomPacketPayload)new PartyInvitePacket("", party.getPartyId(), false)));
    }
}

