/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.party.network;

import com.toukun.mymod.party.network.PartyPlayerData;
import com.toukun.mymod.party.serialization.Party;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class PartyUpdateData {
    private static final String LEADER_TAG = "leader";
    private static final String FOR_NEW_TAG = "for_new_member";
    private static final String PARTY_NAME_TAG = "party_name";
    private static final String MEMBER_LIST_TAG = "members";
    private static final String REMOVED_TAG = "removed";
    private final UUID leaderId;
    private final boolean forNewMember;
    private final String partyName;
    private final List<PartyPlayerData> memberDataList = new ArrayList<PartyPlayerData>();
    @Nullable
    private UUID removedPlayer;

    public PartyUpdateData(Party party) {
        this(party, false);
    }

    public PartyUpdateData(Party party, boolean forNewMember) {
        this(party.getLeaderId(), party.getPartyName(), forNewMember);
    }

    public PartyUpdateData(UUID leaderUuid, String partyName, boolean forNewMember) {
        this.leaderId = leaderUuid;
        this.partyName = partyName;
        this.forNewMember = forNewMember;
    }

    public static PartyUpdateData createInitData(Party party, List<ServerPlayer> onlineMembers, boolean newMember) {
        PartyUpdateData data = new PartyUpdateData(party, newMember);
        data.populateFromParty(party, onlineMembers);
        return data;
    }

    public static PartyUpdateData createRemovalData(Party party, UUID removedId) {
        PartyUpdateData data = new PartyUpdateData(party);
        data.setRemovedPlayer(removedId);
        return data;
    }

    public static PartyUpdateData createUpdateData(Party party, ServerPlayer playerToUpdate, float healthAdjustment) {
        PartyUpdateData data = new PartyUpdateData(party);
        data.addPlayerData(playerToUpdate, healthAdjustment);
        return data;
    }

    public static PartyUpdateData createLogoutData(Party party, ServerPlayer player) {
        PartyUpdateData data = new PartyUpdateData(party);
        data.addAbsentPlayer(player.getUUID(), player.getName().getString());
        return data;
    }

    public static PartyUpdateData load(@Nullable CompoundTag tag) {
        Objects.requireNonNull(tag);
        UUID leaderId = tag.getUUID(LEADER_TAG);
        String partyName = tag.getString(PARTY_NAME_TAG);
        boolean forNewMember = tag.getBoolean(FOR_NEW_TAG);
        PartyUpdateData data = new PartyUpdateData(leaderId, partyName, forNewMember);
        ListTag members = tag.getList(MEMBER_LIST_TAG, 10);
        for (int i = 0; i < members.size(); ++i) {
            CompoundTag memberTag = members.getCompound(i);
            data.addMemberData(PartyPlayerData.load(memberTag));
        }
        if (tag.contains(REMOVED_TAG)) {
            data.setRemovedPlayer(tag.getUUID(REMOVED_TAG));
        }
        return data;
    }

    public void populateFromParty(Party party, List<ServerPlayer> onlineMembers) {
        int i;
        HashMap<UUID, ServerPlayer> map = new HashMap<UUID, ServerPlayer>();
        for (i = 0; i < onlineMembers.size(); ++i) {
            ServerPlayer player = onlineMembers.get(i);
            map.put(player.getUUID(), player);
        }
        UUID[] members = party.getMembers().toArray(new UUID[1]);
        for (i = 0; i < members.length; ++i) {
            UUID memberId = members[i];
            ServerPlayer player = (ServerPlayer)map.get(memberId);
            if (player != null) {
                this.addPlayerData(player);
                continue;
            }
            this.addAbsentPlayer(memberId, party.getMemberName(memberId));
        }
    }

    public void addMemberData(PartyPlayerData data) {
        this.memberDataList.add(data);
    }

    public void addPlayerData(ServerPlayer player) {
        this.addPlayerData(player, 0.0f);
    }

    public void addPlayerData(ServerPlayer player, float healthAdjustment) {
        UUID playerId = player.getUUID();
        PartyPlayerData partyPlayerData = new PartyPlayerData(playerId, player.getName().getString(), true, player.getHealth() + healthAdjustment, player.getMaxHealth());
        this.addMemberData(partyPlayerData);
    }

    public void addAbsentPlayer(UUID memberId, @Nullable String name) {
        PartyPlayerData data = new PartyPlayerData(memberId, name == null ? "Unknown" : name, false, 0.0f, 0.0f);
        this.addMemberData(data);
    }

    public UUID getLeaderId() {
        return this.leaderId;
    }

    public boolean isForNewMember() {
        return this.forNewMember;
    }

    public String getPartyName() {
        return this.partyName;
    }

    public List<PartyPlayerData> getMemberDataList() {
        return this.memberDataList;
    }

    @Nullable
    public UUID getRemovedPlayer() {
        return this.removedPlayer;
    }

    public void setRemovedPlayer(UUID removedPlayer) {
        this.removedPlayer = removedPlayer;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID(LEADER_TAG, this.leaderId);
        tag.putString(PARTY_NAME_TAG, this.partyName);
        tag.putBoolean(FOR_NEW_TAG, this.forNewMember);
        ListTag members = new ListTag();
        for (int i = 0; i < this.memberDataList.size(); ++i) {
            PartyPlayerData memberData = this.memberDataList.get(i);
            members.add((Object)memberData.save());
        }
        tag.put(MEMBER_LIST_TAG, (Tag)members);
        if (this.removedPlayer != null) {
            tag.putUUID(REMOVED_TAG, this.removedPlayer);
        }
        return tag;
    }
}

