/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.party.serialization;

import com.mojang.logging.LogUtils;
import com.toukun.mymod.party.exceptions.LeadershipTransferFailedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.slf4j.Logger;

public class Party {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CAPACITY = 6;
    private static final String LEADER_ID_TAG = "leader";
    private static final String NAME_TAG = "name";
    private static final String ID_TAG = "id";
    private static final String MEMBERS_TAG = "members";
    private static final String MEMBER_NAMES_TAG = "member_names";
    private final Set<UUID> members = new HashSet<UUID>();
    private final Set<UUID> invited = new HashSet<UUID>();
    private final Map<UUID, String> nameMap = new HashMap<UUID, String>();
    private final UUID id;
    private UUID leaderId;
    private String partyName;
    private boolean dirty = false;

    public Party(UUID leaderId, String leaderName) {
        this(leaderId, leaderName, UUID.randomUUID(), Party.createDefaultName(leaderName));
    }

    public Party(UUID leaderId, String leaderName, UUID partyId, String partyName) {
        this.leaderId = leaderId;
        this.id = partyId;
        this.members.add(leaderId);
        this.nameMap.put(leaderId, leaderName);
        this.partyName = partyName;
        this.dirty = false;
    }

    public static String createDefaultName(String partyLeader) {
        return String.format("%s's Party", partyLeader);
    }

    public static Party load(CompoundTag tag) {
        String memberName;
        UUID memberId;
        boolean result;
        LOGGER.debug("load init {}", (Object)tag);
        UUID partyId = tag.getUUID(ID_TAG);
        UUID leader = tag.getUUID(LEADER_ID_TAG);
        String partyName = tag.getString(NAME_TAG);
        Party party = new Party(leader, "", partyId, partyName);
        ListTag members = tag.getList(MEMBERS_TAG, 11);
        ListTag names = tag.getList(MEMBER_NAMES_TAG, 8);
        for (int i = 0; i < members.size() && (result = party.addMember(memberId = NbtUtils.loadUUID((Tag)members.get(i)), memberName = names.getString(i))); ++i) {
        }
        LOGGER.debug("load complete");
        party.setDirty(false);
        return party;
    }

    public static boolean HasRequiredTags(CompoundTag tag) {
        return tag.contains(LEADER_ID_TAG) && tag.contains(NAME_TAG) && tag.contains(MEMBERS_TAG) && tag.contains(MEMBER_NAMES_TAG);
    }

    private void setDirty() {
        this.dirty = true;
    }

    public boolean hasMember(UUID memberId) {
        return this.members.contains(memberId);
    }

    public boolean addMember(UUID memberId, String memberName) {
        if (this.isAtCapacity()) {
            return false;
        }
        this.members.add(memberId);
        this.nameMap.put(memberId, memberName);
        if (!this.invited.isEmpty()) {
            this.invited.removeIf(uuid -> uuid.equals(memberId));
        }
        this.setDirty();
        return true;
    }

    public boolean removeMember(UUID memberId) throws LeadershipTransferFailedException {
        if (!this.hasMember(memberId)) {
            return false;
        }
        if (this.leaderId.equals(memberId)) {
            Optional<UUID> possibleLeader = this.members.stream().filter(member -> !member.equals(memberId)).findFirst();
            if (possibleLeader.isEmpty()) {
                throw new LeadershipTransferFailedException();
            }
            this.leaderId = possibleLeader.get();
        }
        boolean result = this.members.remove(memberId);
        this.nameMap.remove(memberId);
        this.setDirty(result);
        return result;
    }

    public boolean changePartyLeader(UUID newLeaderId) {
        if (!this.members.contains(newLeaderId)) {
            return false;
        }
        this.leaderId = newLeaderId;
        this.setDirty();
        return true;
    }

    public CompoundTag save() {
        return this.save(new CompoundTag());
    }

    public CompoundTag save(CompoundTag tag) {
        LOGGER.debug("save init");
        tag.putUUID(ID_TAG, this.id);
        tag.putUUID(LEADER_ID_TAG, this.leaderId);
        tag.putString(NAME_TAG, this.partyName);
        ListTag members = new ListTag();
        ListTag names = new ListTag();
        UUID[] memberArray = this.members.toArray(new UUID[0]);
        for (int i = 0; i < memberArray.length; ++i) {
            UUID member = memberArray[i];
            String name = this.getMemberName(member);
            members.add((Object)NbtUtils.createUUID((UUID)member));
            if (name == null) continue;
            names.add((Object)StringTag.valueOf((String)name));
        }
        tag.put(MEMBERS_TAG, (Tag)members);
        tag.put(MEMBER_NAMES_TAG, (Tag)names);
        this.dirty = false;
        LOGGER.debug("save complete");
        LOGGER.debug("saved tag {}", (Object)tag);
        return tag;
    }

    public String getPartyName() {
        return this.partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
        this.setDirty();
    }

    public UUID getPartyId() {
        return this.id;
    }

    public boolean isAtCapacity() {
        return this.members.size() >= 6;
    }

    public boolean inviteMember(UUID invitee) {
        if (this.isAtCapacity()) {
            return false;
        }
        this.invited.add(invitee);
        return true;
    }

    public void removeInvite(UUID invitedId) {
        this.invited.remove(invitedId);
    }

    public boolean isInvited(UUID potential) {
        return this.invited.contains(potential);
    }

    public int invitedCount() {
        return this.invited.size();
    }

    public Set<UUID> getInvited() {
        return new HashSet<UUID>(this.invited);
    }

    public UUID getLeaderId() {
        return this.leaderId;
    }

    public boolean isLeader(UUID target) {
        return this.leaderId.equals(target);
    }

    public Set<UUID> getMembers() {
        return new HashSet<UUID>(this.members);
    }

    @Nullable
    public String getMemberName(UUID memberId) {
        return this.nameMap.get(memberId);
    }

    public boolean getDirty() {
        return this.dirty;
    }

    private void setDirty(boolean value) {
        this.dirty = this.dirty || value;
    }
}

