/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.party.serialization;

import com.mojang.logging.LogUtils;
import com.toukun.mymod.party.serialization.Party;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class PartySavedData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PARTY_SAVED_DATA_TAG = "party_save_data";
    private static final String PARTY_TAG = "parties";
    private final Map<UUID, Party> partyMap = new HashMap<UUID, Party>();

    public static PartySavedData load(CompoundTag tag) {
        LOGGER.debug("load init {}", (Object)tag);
        PartySavedData partySavedData = new PartySavedData();
        if (tag.contains(PARTY_TAG, 9)) {
            ListTag parties = tag.getList(PARTY_TAG, 10);
            for (int i = 0; i < parties.size(); ++i) {
                CompoundTag party = parties.getCompound(i);
                if (!Party.HasRequiredTags(party)) continue;
                partySavedData.addParty(Party.load(party));
            }
        }
        partySavedData.setDirty(false);
        LOGGER.debug("load complete");
        return partySavedData;
    }

    public static PartySavedData getPartySavedData(ServerLevel level) {
        return (PartySavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(PartySavedData::create, PartySavedData::load), PARTY_SAVED_DATA_TAG);
    }

    public static PartySavedData create() {
        return new PartySavedData();
    }

    public CompoundTag save(CompoundTag tag) {
        LOGGER.debug("save init");
        ListTag parties = new ListTag();
        this.partyMap.forEach((partyId, party) -> {
            CompoundTag partyTag = party.save();
            parties.add((Object)partyTag);
        });
        tag.put(PARTY_TAG, (Tag)parties);
        this.setDirty(false);
        LOGGER.debug("save complete");
        LOGGER.debug("saved tag {}", (Object)tag);
        return tag;
    }

    public boolean isDirty() {
        return super.isDirty() || this.partyMap.values().stream().anyMatch(Party::getDirty);
    }

    public Optional<Party> findPartyByID(UUID partyId) {
        return Optional.ofNullable(this.partyMap.get(partyId));
    }

    public Optional<Party> findFirstByMember(UUID memberId) {
        return this.partyMap.values().stream().filter(party -> party.hasMember(memberId)).findFirst();
    }

    public void addParty(Party party) {
        this.partyMap.put(party.getPartyId(), party);
    }

    public Party createParty(UUID leaderId, String leaderName) {
        Party party = new Party(leaderId, leaderName);
        this.addParty(party);
        this.setDirty();
        return party;
    }

    public void removeParty(UUID partyId) {
        Party removed = this.partyMap.remove(partyId);
        if (removed != null) {
            this.setDirty();
        }
    }
}

