/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.quests;

import com.toukun.mymod.quests.InvalidQuestIDException;
import com.toukun.mymod.quests.QuestData;
import com.toukun.mymod.quests.QuestMaps;
import com.toukun.mymod.quests.QuestTier;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public enum QuestTiers implements QuestTier
{
    EASY("quests/easy_quests", QuestMaps.EASY_TIER_MAP);

    private final ResourceLocation lootTableLocation;
    private final Map<Byte, QuestData> questDataHashMap;

    private QuestTiers(String lootTableLocation, Map<Byte, QuestData> questDataHashMap) {
        this.lootTableLocation = new ResourceLocation("toukun", lootTableLocation);
        this.questDataHashMap = questDataHashMap;
    }

    @Override
    public QuestData getQuestData(byte questID) throws InvalidQuestIDException {
        if (questID > this.questDataHashMap.size()) {
            throw new InvalidQuestIDException(questID);
        }
        QuestData questData = this.questDataHashMap.get(questID);
        if (questData == null) {
            throw new InvalidQuestIDException(questID);
        }
        return questData;
    }

    @Override
    public LootTable getLootTable() {
        return ServerLifecycleHooks.getCurrentServer().getLootData().getLootTable(this.lootTableLocation);
    }

    @Override
    public Set<Byte> getQuestIDs() {
        return this.questDataHashMap.keySet();
    }

    @Override
    public byte getRandomQuestID(RandomSource randomSource) {
        Set<Byte> ids = this.getQuestIDs();
        byte[] bytes = new byte[ids.size()];
        int i = 0;
        Iterator<Byte> iterator = ids.iterator();
        while (iterator.hasNext()) {
            byte id;
            bytes[i] = id = iterator.next().byteValue();
            ++i;
        }
        return Array.getByte(bytes, randomSource.nextInt(this.questDataHashMap.size()));
    }
}

