/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.recipe;

import com.toukun.mymod.item.custom.PortalStoneItem;
import com.toukun.mymod.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PortalStoneDuplicateRecipe
extends CustomRecipe {
    public PortalStoneDuplicateRecipe(CraftingBookCategory bookCategory) {
        super(bookCategory);
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ItemStack originStack = null;
        ItemStack duplicateStack = null;
        for (int i = 0; i < craftingContainer.getContainerSize(); ++i) {
            ItemStack currentStack = craftingContainer.getItem(i);
            if (currentStack.isEmpty()) continue;
            Item currentItem = currentStack.getItem();
            if (!(currentItem instanceof PortalStoneItem)) {
                return false;
            }
            if (PortalStoneItem.isAttunedPortalStone(currentStack)) {
                if (originStack != null) {
                    return false;
                }
                originStack = currentStack;
                continue;
            }
            if (duplicateStack != null) {
                return false;
            }
            duplicateStack = currentStack;
        }
        return originStack != null && duplicateStack != null;
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        for (int i = 0; i < craftingContainer.getContainerSize(); ++i) {
            ItemStack currentStack = craftingContainer.getItem(i);
            if (currentStack.isEmpty() || !PortalStoneItem.isAttunedPortalStone(currentStack)) continue;
            ItemStack duplicateStack = currentStack.copy();
            duplicateStack.setCount(1);
            return duplicateStack;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer craftingContainer) {
        NonNullList itemStacks = NonNullList.withSize((int)craftingContainer.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack itemstack = craftingContainer.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (itemstack.hasCraftingRemainingItem()) {
                itemStacks.set(i, (Object)itemstack.getCraftingRemainingItem());
                continue;
            }
            if (!itemstack.hasTag() || !PortalStoneItem.isAttunedPortalStone(itemstack)) continue;
            ItemStack itemstack1 = itemstack.copy();
            itemstack1.setCount(1);
            itemStacks.set(i, (Object)itemstack1);
        }
        return itemStacks;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.PORTAL_STONE_DUPLICATE_SERIALIZER.get();
    }
}

