/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.screen.party;

import com.toukun.mymod.party.PartySystem;
import com.toukun.mymod.screen.ModMenuTypes;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class PartyMenu
extends AbstractContainerMenu {
    public static final String MENU_TITLE = "party.menu.title";
    public static final int CREATE_BUTTON_ID = 1;
    public static final int ACCEPT_INVITE_ID = 2;
    public static final int REJECT_INVITE_ID = 3;
    public static final int LEAVE_PARTY_ID = 4;
    public static final int DISBAND_PARTY_ID = 5;
    public static final int PROMOTE_PARTY_ID = 6;
    public static final int KICK_PARTY_ID = 7;
    public static final int EDIT_NAME_ID = 8;
    public static final int TELEPORT_ID = 9;
    private static final Set<Integer> IGNORE_IDS = new HashSet<Integer>();
    private final Player player;

    public PartyMenu(int id, Inventory inventory) {
        super(ModMenuTypes.PARTY_MENU.get(), id);
        this.player = inventory.player;
    }

    public PartyMenu(int id, Inventory inventory, @Nullable FriendlyByteBuf byteBuf) {
        this(id, inventory);
    }

    public ItemStack quickMoveStack(Player player, int id) {
        return null;
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            return false;
        }
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PartySystem system = new PartySystem(serverPlayer.getServer());
        if (IGNORE_IDS.contains(id)) {
            return true;
        }
        if (id == 1) {
            system.createParty(serverPlayer);
            return true;
        }
        if (id == 4) {
            system.leaveParty(serverPlayer);
            return true;
        }
        if (id == 5) {
            system.disbandParty(serverPlayer);
            return true;
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean isCurrentPlayer(UUID playerId) {
        return this.player.getUUID().equals(playerId);
    }

    public boolean isMenuOwner(UUID leaderId) {
        return this.player.getUUID().equals(leaderId);
    }

    static {
        IGNORE_IDS.add(2);
        IGNORE_IDS.add(3);
        IGNORE_IDS.add(6);
        IGNORE_IDS.add(7);
        IGNORE_IDS.add(8);
        IGNORE_IDS.add(9);
    }
}

