/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.screen.party;

import com.mojang.blaze3d.systems.RenderSystem;
import com.toukun.mymod.client.party.ClientPartyData;
import com.toukun.mymod.client.utility.rendering.ButtonRenderer;
import com.toukun.mymod.client.utility.rendering.ButtonSizes;
import com.toukun.mymod.client.utility.rendering.ButtonTypes;
import com.toukun.mymod.client.utility.rendering.FontColors;
import com.toukun.mymod.client.utility.rendering.TextRenderer;
import com.toukun.mymod.party.network.PartyPlayerData;
import com.toukun.mymod.screen.party.PartyMenu;
import com.toukun.mymod.screen.party.PartyScreenTooltips;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PartyScreen
extends AbstractContainerScreen<PartyMenu> {
    private static final ResourceLocation DEFAULT_BACKGROUND = new ResourceLocation("toukun", "textures/gui/container/party/default.png");
    private static final ResourceLocation MEMBER_BACKGROUND = new ResourceLocation("toukun", "textures/gui/container/party/member.png");
    private static final ResourceLocation LEADER_BACKGROUND = new ResourceLocation("toukun", "textures/gui/container/party/leader.png");
    private static final ResourceLocation CROWN_ICON = new ResourceLocation("toukun", "textures/gui/sprites/menu/party/crown.png");
    private static final ResourceLocation CHECK_ICON = new ResourceLocation("toukun", "textures/gui/sprites/menu/party/check.png");
    private static final ResourceLocation X_ICON = new ResourceLocation("toukun", "textures/gui/sprites/menu/party/x.png");
    private static final ResourceLocation STATUS_INDICATORS = new ResourceLocation("toukun", "textures/gui/sprites/menu/party/status.png");
    private static final String CREATE_TEXT = "party.menu.create";
    private static final String INVITES_TEXT = "party.menu.invites";
    private static final String LEAVE_TEXT = "party.menu.leave";
    private static final String DISBAND_TEXT = "party.menu.disband";
    private static final ButtonSizes MAJOR_SIZE = ButtonSizes.SIZE_84;
    private static final ButtonSizes MIDDLE_SIZE = ButtonSizes.SIZE_48;
    private static final ButtonSizes ICON_SIZE = ButtonSizes.SIZE_16;
    @Nullable
    private Component tooltipText;
    private int centeredX;
    private int topRowY;
    private int inviteX;
    private int inviteDeclineX;
    private int inviteY;
    private int subtitleLabelY;
    private int editBoxX;
    private int editBoxY;
    private int editBoxAcceptX;
    private int memberY;
    private int memberLeaveX;
    private int bottomRowY;
    private int memberLeaderX;
    private int memberPromoteX;
    private int memberRemoveX;
    private int leaderLeaveX;
    private int leaderDisbandX;
    private EditBox partyName;
    private String workingName;

    public PartyScreen(PartyMenu partyMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)partyMenu, inventory, component);
    }

    protected void init() {
        super.init();
        this.centeredX = this.leftPos + 46;
        this.topRowY = this.topPos + 20;
        this.inviteX = this.leftPos + 35;
        this.subtitleLabelY = 38;
        this.inviteY = this.topPos + 49;
        this.inviteDeclineX = this.inviteX + MAJOR_SIZE.getSize() + 3;
        this.editBoxX = this.leftPos + 37;
        this.editBoxY = this.topRowY + 4;
        this.editBoxAcceptX = this.editBoxX + MAJOR_SIZE.getSize() + 4;
        this.memberY = this.topPos + 41;
        this.memberLeaveX = this.leftPos + 64;
        this.bottomRowY = this.topPos + 141;
        this.memberLeaderX = this.leftPos + 26;
        this.memberPromoteX = this.memberLeaderX + MAJOR_SIZE.getSize() + 5;
        this.memberRemoveX = this.memberPromoteX + ICON_SIZE.getSize() + 3;
        this.leaderLeaveX = this.leftPos + 26;
        this.leaderDisbandX = this.leaderLeaveX + MIDDLE_SIZE.getSize() + 28;
        this.partyNameInit();
    }

    private void partyNameInit() {
        this.workingName = ClientPartyData.getPartyName().getString();
        this.partyName = new EditBox(this.font, this.editBoxX, this.editBoxY, MAJOR_SIZE.getSize() - 10, 16, PartyScreenTooltips.getEditboxComponent());
        this.partyName.setCanLoseFocus(true);
        this.partyName.setTextColor(FontColors.EDIT_MODE.getColor());
        this.partyName.setTextColorUneditable(FontColors.EDIT_MODE.getColor());
        this.partyName.setBordered(false);
        this.partyName.setMaxLength(32);
        this.partyName.setResponder(string -> {
            this.workingName = string;
        });
        this.partyName.setValue(this.workingName);
        this.addWidget((GuiEventListener)this.partyName);
        this.partyName.setEditable(true);
        this.partyName.setTooltip(PartyScreenTooltips.getEditboxTooltip());
        this.partyName.setCursorPosition(0);
        this.partyName.setHighlightPos(0);
    }

    private boolean partyNameEdited() {
        return !this.workingName.equals(ClientPartyData.getPartyName().getString());
    }

    private boolean isNotMember() {
        return ClientPartyData.isEmpty();
    }

    private boolean isClientPlayer(UUID id) {
        return ((PartyMenu)this.menu).isMenuOwner(id);
    }

    private boolean isClientPlayerLeader() {
        return ((PartyMenu)this.menu).isMenuOwner(ClientPartyData.getLeaderId());
    }

    private boolean isPlayerLeader(UUID id) {
        return id.equals(ClientPartyData.getLeaderId());
    }

    private ButtonTypes getButtonType(int x, int y, int width, int mouseX, int mouseY, @Nullable Component tooltip) {
        boolean isHovering = this.isHovering(x, y, width, mouseX, mouseY);
        if (isHovering) {
            if (tooltip != null && this.tooltipText == null) {
                this.tooltipText = tooltip;
            }
            return ButtonTypes.HOVERED;
        }
        return ButtonTypes.DEFAULT;
    }

    private ButtonTypes getMemberButtonTypes(PartyPlayerData data, int x, int y, int mouseX, int mouseY) {
        boolean isDisabled;
        boolean isHovering = this.isHovering(x, y, MAJOR_SIZE.getSize(), mouseX, mouseY);
        UUID id = data.id();
        boolean bl = isDisabled = ((PartyMenu)this.menu).isCurrentPlayer(id) || !data.online() || !ClientPartyData.canTeleport();
        if (isHovering && this.tooltipText == null) {
            this.tooltipText = PartyScreenTooltips.getTeleportTooltipComponent(id);
            if (isDisabled) {
                return ButtonTypes.DISABLED;
            }
            return ButtonTypes.HOVERED;
        }
        if (isDisabled) {
            return ButtonTypes.DISABLED;
        }
        return ButtonTypes.DEFAULT;
    }

    private ButtonTypes getMemberButtonTypes(PartyPlayerData data, int y, int mouseX, int mouseY) {
        return this.getMemberButtonTypes(data, this.centeredX, y, mouseX, mouseY);
    }

    private ButtonTypes getMemberButtonTypesForLeader(PartyPlayerData data, int y, int mouseX, int mouseY) {
        return this.getMemberButtonTypes(data, this.memberLeaderX, y, mouseX, mouseY);
    }

    private ButtonTypes getEditPartyNameType(int mouseX, int mouseY) {
        boolean shouldBeDisabled;
        boolean isHovering = this.isHovering(this.editBoxAcceptX, this.topRowY, ICON_SIZE.getSize(), mouseX, mouseY);
        boolean bl = shouldBeDisabled = !this.partyNameEdited();
        if (isHovering && this.tooltipText == null) {
            this.tooltipText = PartyScreenTooltips.getRenamePartyTooltip(shouldBeDisabled, this.workingName);
            if (shouldBeDisabled) {
                return ButtonTypes.DISABLED;
            }
            return ButtonTypes.HOVERED;
        }
        if (shouldBeDisabled) {
            return ButtonTypes.DISABLED;
        }
        return ButtonTypes.DEFAULT;
    }

    private ButtonTypes getPromoteButtonTypes(int rowY, int mouseX, int mouseY, boolean isLeader, String playerName) {
        boolean isHovering = this.isHovering(this.memberPromoteX, rowY, ICON_SIZE.getSize(), mouseX, mouseY);
        if (isHovering && this.tooltipText == null) {
            this.tooltipText = PartyScreenTooltips.getPromotePlayerTooltip(isLeader, playerName);
            if (isLeader) {
                return ButtonTypes.DISABLED;
            }
            return ButtonTypes.HOVERED;
        }
        if (isLeader) {
            return ButtonTypes.DISABLED;
        }
        return ButtonTypes.DEFAULT;
    }

    private boolean isHovering(int x, int y, int width, int mouseX, int mouseY) {
        int relativeMouseX = mouseX - x;
        int relativeMouseY = mouseY - y;
        return relativeMouseX >= 0 && relativeMouseX < width && relativeMouseY >= 0 && relativeMouseY < 16;
    }

    private int defaultMouseClicked(int x, int y) {
        if (this.isHovering(this.centeredX, this.topRowY, MAJOR_SIZE.getSize(), x, y)) {
            return 1;
        }
        int limit = Math.min(ClientPartyData.getInviteCount(), 6);
        if (limit == 0) {
            return 0;
        }
        AtomicInteger response = new AtomicInteger(0);
        ClientPartyData.iterateOverInvites((invite, i) -> {
            if (i >= limit || response.get() > 0) {
                return;
            }
            UUID id = invite.partyId();
            int inviteRowY = this.inviteY + 16 * i;
            if (this.isHovering(this.inviteX, inviteRowY, MAJOR_SIZE.getSize(), x, y)) {
                ClientPartyData.acceptInvite(id);
                response.set(2);
            } else if (this.isHovering(this.inviteDeclineX, inviteRowY, ICON_SIZE.getSize(), x, y)) {
                ClientPartyData.ignoreInvite(id);
                response.set(3);
            }
        });
        return response.get();
    }

    private int memberMouseClicked(int x, int y) {
        if (this.isHovering(this.memberLeaveX, this.bottomRowY, MIDDLE_SIZE.getSize(), x, y)) {
            return 4;
        }
        int limit = Math.min(ClientPartyData.getMemberCount(), 6);
        if (limit == 0) {
            return 0;
        }
        AtomicInteger response = new AtomicInteger(0);
        ClientPartyData.iterateOverMembers((member, i) -> {
            if (i >= limit || response.get() > 0) {
                return;
            }
            UUID memberId = member.id();
            int memberRowY = this.memberY + 16 * i;
            if (this.isHovering(this.centeredX, memberRowY, MAJOR_SIZE.getSize(), x, y)) {
                ClientPartyData.teleportToMember(memberId);
                response.set(9);
            }
        });
        return response.get();
    }

    private int handleEdit() {
        if (!this.partyNameEdited() || this.partyName == null) {
            return 0;
        }
        ClientPartyData.changeName(this.workingName);
        this.partyName.setFocused(false);
        return 8;
    }

    private int leaderMouseClicked(int x, int y) {
        if (this.isHovering(this.editBoxAcceptX, this.topRowY, ICON_SIZE.getSize(), x, y)) {
            return this.handleEdit();
        }
        if (this.isHovering(this.leaderLeaveX, this.bottomRowY, MIDDLE_SIZE.getSize(), x, y)) {
            return 4;
        }
        if (this.isHovering(this.leaderDisbandX, this.bottomRowY, MIDDLE_SIZE.getSize(), x, y)) {
            return 5;
        }
        int limit = Math.min(ClientPartyData.getMemberCount(), 6);
        if (limit == 0) {
            return 0;
        }
        AtomicInteger response = new AtomicInteger(0);
        ClientPartyData.iterateOverMembers((member, i) -> {
            if (i >= limit || response.get() > 0) {
                return;
            }
            UUID memberId = member.id();
            int memberRowY = this.memberY + 16 * i;
            if (this.isHovering(this.memberLeaderX, memberRowY, MAJOR_SIZE.getSize(), x, y)) {
                ClientPartyData.teleportToMember(memberId);
                response.set(9);
            }
            if (this.isHovering(this.memberPromoteX, memberRowY, ICON_SIZE.getSize(), x, y)) {
                ClientPartyData.promoteMember(memberId);
                response.set(6);
            } else if (this.isHovering(this.memberRemoveX, memberRowY, ICON_SIZE.getSize(), x, y)) {
                ClientPartyData.kickMember(memberId);
                response.set(7);
            }
        });
        return response.get();
    }

    public boolean mouseClicked(double x, double y, int mouseKeyCode) {
        int id = this.isNotMember() ? this.defaultMouseClicked((int)x, (int)y) : (this.isClientPlayerLeader() ? this.leaderMouseClicked((int)x, (int)y) : this.memberMouseClicked((int)x, (int)y));
        if (this.minecraft == null) {
            return false;
        }
        MultiPlayerGameMode gameMode = this.minecraft.gameMode;
        if (gameMode == null) {
            return false;
        }
        if (id > 0) {
            gameMode.handleInventoryButtonClick(((PartyMenu)this.menu).containerId, id);
            return true;
        }
        return super.mouseClicked(x, y, mouseKeyCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.partyNameEdited()) {
                this.workingName = ClientPartyData.getPartyName().getString();
                this.partyName.setValue(this.workingName);
                this.partyName.setFocused(false);
                return true;
            }
            if (this.minecraft != null && this.minecraft.player != null) {
                this.minecraft.player.closeContainer();
            }
        }
        if (keyCode == 257 && this.partyNameEdited()) {
            ClientPartyData.changeName(this.workingName);
            this.partyName.setFocused(false);
            return true;
        }
        if (this.partyName.keyPressed(keyCode, scanCode, modifiers) || this.partyName.canConsumeInput()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void initRenderBg() {
        if (this.tooltipText != null) {
            this.tooltipText = null;
        }
        if (ClientPartyData.isEmpty() && !this.partyName.getValue().isEmpty()) {
            this.partyName.setValue("");
            this.workingName = this.partyName.getValue();
        }
        if (this.partyName.getValue().isEmpty() && !ClientPartyData.isEmpty()) {
            this.partyName.setValue(ClientPartyData.getPartyName().getString());
            this.workingName = this.partyName.getValue();
            this.partyName.setCursorPosition(0);
            this.partyName.setHighlightPos(0);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.initRenderBg();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean isDefault = ClientPartyData.isEmpty();
        boolean isLeader = this.isClientPlayerLeader();
        if (isDefault) {
            this.renderDefault(guiGraphics, mouseX, mouseY);
        } else if (isLeader) {
            this.renderLeader(guiGraphics, partialTick, mouseX, mouseY);
        } else {
            this.renderMember(guiGraphics, mouseX, mouseY);
        }
        if (this.tooltipText != null) {
            guiGraphics.renderTooltip(this.font, this.tooltipText, mouseX, mouseY);
        }
    }

    private void renderDefault(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DEFAULT_BACKGROUND);
        guiGraphics.blit(DEFAULT_BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        ButtonTypes type = this.getButtonType(this.centeredX, this.topRowY, MAJOR_SIZE.getSize(), mouseX, mouseY, PartyScreenTooltips.getCreatePartyTooltip());
        ButtonRenderer.renderButtonWithLabel(guiGraphics, MAJOR_SIZE, type, this.centeredX, this.topRowY, (Component)Component.translatable((String)CREATE_TEXT), this.font);
        int limit = Math.min(ClientPartyData.getInviteCount(), 6);
        if (limit == 0) {
            return;
        }
        ClientPartyData.iterateOverInvites((invite, i) -> {
            if (i >= limit) {
                return;
            }
            int inviteRowY = this.inviteY + 16 * i;
            String partyName = invite.partyName();
            ButtonTypes nameType = this.getButtonType(this.inviteX, inviteRowY, MAJOR_SIZE.getSize(), mouseX, mouseY, PartyScreenTooltips.getJoinPartyTooltip(partyName));
            ButtonRenderer.renderButtonWithLabel(guiGraphics, MAJOR_SIZE, nameType, this.inviteX, inviteRowY, (Component)Component.literal((String)partyName), this.font);
            ButtonTypes declineType = this.getButtonType(this.inviteDeclineX, inviteRowY, ICON_SIZE.getSize(), mouseX, mouseY, PartyScreenTooltips.getIgnoreInviteTooltip(partyName));
            ButtonRenderer.renderIconButton(guiGraphics, declineType, this.inviteDeclineX, inviteRowY, X_ICON);
        });
    }

    private void renderMember(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MEMBER_BACKGROUND);
        guiGraphics.blit(MEMBER_BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        TextRenderer.renderTruncatedButtonLabel(guiGraphics, this.font, ClientPartyData.getPartyName(), MAJOR_SIZE.getSize(), FontColors.EDIT_MODE, this.centeredX, this.topRowY);
        ButtonTypes leaveType = this.getButtonType(this.memberLeaveX, this.bottomRowY, MIDDLE_SIZE.getSize(), mouseX, mouseY, PartyScreenTooltips.getLeavePartyTooltip());
        ButtonRenderer.renderButtonWithLabel(guiGraphics, MIDDLE_SIZE, leaveType, this.memberLeaveX, this.bottomRowY, (Component)Component.translatable((String)LEAVE_TEXT), this.font);
        int limit = Math.min(ClientPartyData.getMemberCount(), 6);
        if (limit == 0) {
            return;
        }
        ClientPartyData.iterateOverMembers((member, i) -> {
            if (i >= limit) {
                return;
            }
            int memberRowY = this.memberY + 16 * i;
            ButtonTypes type = this.getMemberButtonTypes((PartyPlayerData)member, memberRowY, mouseX, mouseY);
            this.renderMemberInfo(guiGraphics, (PartyPlayerData)member, type, this.centeredX, memberRowY);
        });
    }

    private void renderLeader(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LEADER_BACKGROUND);
        guiGraphics.blit(LEADER_BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.partyName.render(guiGraphics, mouseX, mouseY, partialTick);
        ButtonTypes editType = this.getEditPartyNameType(mouseX, mouseY);
        ButtonRenderer.renderIconButton(guiGraphics, editType, this.editBoxAcceptX, this.topRowY, CHECK_ICON);
        ButtonTypes leaveType = this.getButtonType(this.leaderLeaveX, this.bottomRowY, MIDDLE_SIZE.getSize(), mouseX, mouseY, PartyScreenTooltips.getLeavePartyTooltip());
        ButtonRenderer.renderButtonWithLabel(guiGraphics, MIDDLE_SIZE, leaveType, this.leaderLeaveX, this.bottomRowY, (Component)Component.translatable((String)LEAVE_TEXT), this.font);
        ButtonTypes disbandType = this.getButtonType(this.leaderDisbandX, this.bottomRowY, MIDDLE_SIZE.getSize(), mouseX, mouseY, PartyScreenTooltips.getDisbandPartyTooltip());
        ButtonRenderer.renderButtonWithLabel(guiGraphics, MIDDLE_SIZE, disbandType, this.leaderDisbandX, this.bottomRowY, (Component)Component.translatable((String)DISBAND_TEXT), this.font);
        int limit = Math.min(ClientPartyData.getMemberCount(), 6);
        if (limit == 0) {
            return;
        }
        ClientPartyData.iterateOverMembers((member, i) -> {
            if (i >= limit) {
                return;
            }
            int memberRowY = this.memberY + 16 * i;
            ButtonTypes type = this.getMemberButtonTypesForLeader((PartyPlayerData)member, memberRowY, mouseX, mouseY);
            this.renderMemberInfo(guiGraphics, (PartyPlayerData)member, type, this.memberLeaderX, memberRowY);
            UUID playerId = member.id();
            String playerName = member.name();
            ButtonTypes promoteType = this.getPromoteButtonTypes(memberRowY, mouseX, mouseY, this.isPlayerLeader(playerId), playerName);
            ButtonRenderer.renderIconButton(guiGraphics, promoteType, this.memberPromoteX, memberRowY, CROWN_ICON);
            ButtonTypes removeType = this.getButtonType(this.memberRemoveX, memberRowY, ICON_SIZE.getSize(), mouseX, mouseY, PartyScreenTooltips.getRemovePlayerTooltip(playerName, this.isClientPlayer(playerId)));
            ButtonRenderer.renderIconButton(guiGraphics, removeType, this.memberRemoveX, memberRowY, X_ICON);
        });
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        if (this.isNotMember()) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)INVITES_TEXT), this.titleLabelX, this.subtitleLabelY, 0x404040, false);
        }
    }

    private void renderMemberInfo(GuiGraphics guiGraphics, PartyPlayerData member, ButtonTypes type, int x, int y) {
        UUID id = member.id();
        ButtonRenderer.renderButtonWithLabel(guiGraphics, MAJOR_SIZE, type, x, y, (Component)Component.literal((String)member.name()), this.font);
        boolean online = member.online();
        boolean leader = this.isPlayerLeader(id);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)STATUS_INDICATORS);
        if (leader) {
            guiGraphics.blit(STATUS_INDICATORS, x - 2, y, 4.0f, 0.0f, 2, ICON_SIZE.getSize(), ICON_SIZE.getSize(), ICON_SIZE.getSize());
        }
        int statusX = x + MAJOR_SIZE.getSize();
        int statusTextureX = online ? 2 : 0;
        guiGraphics.blit(STATUS_INDICATORS, statusX, y, (float)statusTextureX, 0.0f, 2, ICON_SIZE.getSize(), ICON_SIZE.getSize(), ICON_SIZE.getSize());
    }
}

