/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.screen.party;

import com.toukun.mymod.attachments.party.PartyTeleportAttachmentHelper;
import com.toukun.mymod.client.party.ClientPartyData;
import com.toukun.mymod.party.network.PartyPlayerData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class PartyScreenTooltips {
    private static final String CREATE_TOOLTIP = "party.menu.tooltip.create";
    private static final String JOIN_TOOLTIP = "party.menu.tooltip.join";
    private static final String IGNORE_INVITE_TOOLTIP = "party.menu.tooltip.ignore";
    private static final String LEAVE_PARTY_TOOLTIP = "party.menu.tooltip.leave";
    private static final String DISBAND_PARTY_TOOLTIP = "party.menu.tooltip.disband";
    private static final String RENAME_TOOLTIP = "party.menu.tooltip.rename";
    private static final String SAVE_RENAME_TOOLTIP = "party.menu.tooltip.rename.save";
    private static final String RENAME_DISABLED_TOOLTIP = "party.menu.tooltip.rename.disabled";
    private static final String PROMOTE_TOOLTIP = "party.menu.tooltip.promote";
    private static final String REMOVE_TOOLTIP = "party.menu.tooltip.remove";
    private static final String CANNOT_PROMOTE_SELF_TOOLTIP = "party.menu.tooltip.promote.disabled";
    private static final String TELEPORT_TOOLTIP = "party.menu.tooltip.teleport";
    private static final String TELEPORT_HAS_COOLDOWN_TOOLTIP = "party.menu.tooltip.teleport.cooldown";
    private static final String TELEPORT_OFFLINE_TOOLTIP = "party.menu.tooltip.teleport.offline";
    private static final String TELEPORT_INVALID_TOOLTIP = "party.menu.tooltip.teleport.invalid";
    private static final String TELEPORT_SELF_TOOLTIP = "party.menu.tooltip.teleport.self";

    public static Component getTeleportTooltipComponent(UUID targetId) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && minecraft.player.getUUID().equals(targetId)) {
            return Component.translatable((String)TELEPORT_SELF_TOOLTIP);
        }
        PartyPlayerData target = ClientPartyData.getMemberData(targetId);
        if (target == null) {
            return Component.translatable((String)TELEPORT_INVALID_TOOLTIP);
        }
        String name = target.name();
        if (!target.online()) {
            return Component.translatable((String)TELEPORT_OFFLINE_TOOLTIP, (Object[])new Object[]{name});
        }
        if (!ClientPartyData.canTeleport()) {
            return Component.translatable((String)TELEPORT_HAS_COOLDOWN_TOOLTIP, (Object[])new Object[]{PartyTeleportAttachmentHelper.CooldownInSeconds(ClientPartyData.getTeleportCooldown())});
        }
        return Component.translatable((String)TELEPORT_TOOLTIP, (Object[])new Object[]{name});
    }

    public static Component getCreatePartyTooltip() {
        return Component.translatable((String)CREATE_TOOLTIP);
    }

    public static Component getJoinPartyTooltip(String partyName) {
        return Component.translatable((String)JOIN_TOOLTIP, (Object[])new Object[]{partyName});
    }

    public static Component getIgnoreInviteTooltip(String partyName) {
        return Component.translatable((String)IGNORE_INVITE_TOOLTIP, (Object[])new Object[]{partyName});
    }

    public static Component getLeavePartyTooltip() {
        return Component.translatable((String)LEAVE_PARTY_TOOLTIP, (Object[])new Object[]{ClientPartyData.getPartyName()});
    }

    public static Component getDisbandPartyTooltip() {
        return Component.translatable((String)DISBAND_PARTY_TOOLTIP, (Object[])new Object[]{ClientPartyData.getPartyName()});
    }

    public static Component getRenamePartyTooltip(boolean isDisabled, String newName) {
        if (isDisabled) {
            return Component.translatable((String)RENAME_DISABLED_TOOLTIP);
        }
        return Component.translatable((String)SAVE_RENAME_TOOLTIP, (Object[])new Object[]{newName});
    }

    public static Component getPromotePlayerTooltip(boolean isLeader, String playerName) {
        if (isLeader) {
            return Component.translatable((String)CANNOT_PROMOTE_SELF_TOOLTIP);
        }
        return Component.translatable((String)PROMOTE_TOOLTIP, (Object[])new Object[]{playerName});
    }

    public static Component getRemovePlayerTooltip(String playerName, boolean isLocalPlayer) {
        return Component.translatable((String)REMOVE_TOOLTIP, (Object[])new Object[]{isLocalPlayer ? "yourself" : playerName});
    }

    public static Component getEditboxComponent() {
        return Component.translatable((String)RENAME_TOOLTIP);
    }

    public static Tooltip getEditboxTooltip() {
        return Tooltip.create((Component)PartyScreenTooltips.getEditboxComponent());
    }
}

