/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.screen.questBoard;

import com.toukun.mymod.block.ModBlocks;
import com.toukun.mymod.item.ModItems;
import com.toukun.mymod.item.classes.QuestLogItem;
import com.toukun.mymod.quests.QuestTier;
import com.toukun.mymod.screen.ModMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class QuestBoardMenu
extends AbstractContainerMenu {
    public static final int[] costs = new int[]{4};
    private static final String QUEST_BUTTON = "quest.toukun.board.button";
    private static final String QUEST_ERROR = "quest.toukun.board.error";
    private final Container questBoardSlots = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            QuestBoardMenu.this.slotsChanged((Container)this);
        }
    };
    private final ContainerLevelAccess access;
    private final RandomSource random = RandomSource.create();

    public QuestBoardMenu(int id, Inventory inventory, FriendlyByteBuf byteBuf) {
        this(id, inventory, ContainerLevelAccess.NULL);
    }

    public QuestBoardMenu(int id, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super(ModMenuTypes.QUEST_BOARD_MENU.get(), id);
        this.access = containerLevelAccess;
        this.addSlot(new Slot(this.questBoardSlots, 0, 26, 30){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.is(Tags.Items.GEMS_EMERALD);
            }
        });
        this.addSlot(new Slot(this.questBoardSlots, 1, 134, 30){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addPlayerInventory(inventory);
        this.addPlayerHotBar(inventory);
    }

    private static ItemStack GetQuestItemStackByID(int id) {
        switch (id) {
            case 0: {
                return new ItemStack((ItemLike)ModItems.QUEST_EASY.get());
            }
        }
        return ItemStack.EMPTY;
    }

    public static Component GetNameAndCostComponentByID(int id) {
        if (id >= 0 && id < costs.length) {
            String itemTranslationKey = QuestBoardMenu.GetQuestItemStackByID(id).getDescriptionId();
            return Component.translatable((String)QUEST_BUTTON, (Object[])new Object[]{Component.translatable((String)itemTranslationKey), Component.literal((String)("" + costs[id]))});
        }
        return Component.translatable((String)QUEST_ERROR);
    }

    public int getEmeralds() {
        ItemStack itemstack = this.questBoardSlots.getItem(0);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    public boolean isButtonDisabled(int id) {
        if (!this.questBoardSlots.getItem(1).isEmpty()) {
            return true;
        }
        if (id >= 0 && id < costs.length) {
            return costs[id] > this.getEmeralds();
        }
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((level, container) -> this.clearContainer(player, this.questBoardSlots));
    }

    public boolean stillValid(Player player) {
        return QuestBoardMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.QUEST_BOARD.get()));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.isButtonDisabled(id)) {
            return false;
        }
        if (id >= 0 && id < costs.length) {
            ItemStack emeralds = this.questBoardSlots.getItem(0);
            if (emeralds.isEmpty()) {
                return false;
            }
            int cost = costs[id];
            if (cost > emeralds.getCount()) {
                return false;
            }
            this.access.execute((level, container) -> {
                ItemStack questItem = QuestBoardMenu.GetQuestItemStackByID(id);
                QuestTier questTier = QuestLogItem.GetQuestTier(questItem);
                if (questTier != null) {
                    QuestLogItem.SetQuestID(questItem, questTier.getRandomQuestID(this.random));
                    emeralds.shrink(cost);
                    if (emeralds.isEmpty()) {
                        this.questBoardSlots.setItem(0, ItemStack.EMPTY);
                    }
                    this.questBoardSlots.setItem(1, questItem);
                    this.slotsChanged(this.questBoardSlots);
                    level.playSound(null, container, SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            });
            return true;
        }
        return false;
    }

    public ItemStack quickMoveStack(Player player, int itemSlot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(itemSlot);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (itemSlot == 0 || itemSlot == 1 ? !this.moveItemStackTo(slotStack, 2, 38, true) : slotStack.is(Items.EMERALD) && !this.moveItemStackTo(slotStack, 0, 1, true)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack.getCount() == slotStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotBar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

