/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.screen.questBoard;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.toukun.mymod.screen.questBoard.QuestBoardMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestBoardScreen
extends AbstractContainerScreen<QuestBoardMenu> {
    private static final ResourceLocation QUEST_BOARD_TEXTURE = new ResourceLocation("toukun", "textures/gui/quest_board_gui.png");
    private static final int BUTTON_BLOCK_START_X = 47;
    private static final int BUTTON_BLOCK_START_Y = 17;
    private static final int BUTTON_WIDTH = 84;
    private static final int BUTTON_HEIGHT = 16;
    private static final int BUTTON_TEXT_X_OFFSET = 2;
    private static final int BUTTON_TEXT_Y_OFFSET = 4;
    private final int costsSize = QuestBoardMenu.costs.length;

    public QuestBoardScreen(QuestBoardMenu questBoardMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)questBoardMenu, inventory, component);
    }

    public boolean mouseClicked(double x, double y, int mouseKeyCode) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        for (int k = 0; k < this.costsSize; ++k) {
            MultiPlayerGameMode gameMode;
            Minecraft minecraft;
            double xRelative = x - (double)(i + 47);
            double yRelative = y - (double)(j + 17 + 16 * k);
            if (!(xRelative >= 0.0) || !(xRelative < 84.0) || !(yRelative >= 0.0) || !(yRelative < 16.0) || (minecraft = this.minecraft) == null || (gameMode = minecraft.gameMode) == null) continue;
            minecraft.gameMode.handleInventoryButtonClick(((QuestBoardMenu)this.menu).containerId, k);
            return true;
        }
        return super.mouseClicked(x, y, mouseKeyCode);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        Lighting.setupForFlatItems();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)QUEST_BOARD_TEXTURE);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(QUEST_BOARD_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int xButtonOffset = i + 47;
        int xTextOffset = xButtonOffset + 2;
        for (int i1 = 0; i1 < this.costsSize; ++i1) {
            int yButtonOffset = j + 17 + 16 * i1;
            int yTextOffset = yButtonOffset + 4;
            int relativeMouseX = mouseX - xButtonOffset;
            int relativeMouseY = mouseY - yButtonOffset;
            boolean isMouseHovering = relativeMouseX >= 0 && relativeMouseX < 84 && relativeMouseY >= 0 && relativeMouseY < 16;
            int fontColor = 6839882;
            if (((QuestBoardMenu)this.menu).isButtonDisabled(i1)) {
                guiGraphics.blit(QUEST_BOARD_TEXTURE, xButtonOffset, yButtonOffset, 0, 182, 84, 16);
                fontColor = (fontColor & 0xFEFEFE) >> 1;
            } else if (isMouseHovering) {
                guiGraphics.blit(QUEST_BOARD_TEXTURE, xButtonOffset, yButtonOffset, 0, 198, 84, 16);
                fontColor = 0xFFFF80;
            } else {
                guiGraphics.blit(QUEST_BOARD_TEXTURE, xButtonOffset, yButtonOffset, 0, 166, 84, 16);
            }
            Component text = QuestBoardMenu.GetNameAndCostComponentByID(i1);
            int textWidth = this.font.width(text.getVisualOrderText());
            FormattedText formattedText = this.font.getSplitter().headByWidth((FormattedText)text, textWidth, Style.EMPTY);
            guiGraphics.drawWordWrap(this.font, formattedText, xTextOffset, yTextOffset, textWidth, fontColor);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

