/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.utility;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.phys.Vec3;

public class PortalUtils {
    private static final int[][] PORTAL_OFFSET_ARRAY = PortalUtils.CreateCWRotationalIntegerArray(2);

    public static int[][] CreateCWRotationalIntegerArray(int radius) {
        if (radius == 0) {
            return new int[][]{{0, 0}};
        }
        int absRadius = Math.abs(radius);
        int base = absRadius * 2 + 1;
        int arraySize = base * base;
        int[][] rotationalArray = new int[arraySize][2];
        rotationalArray[0] = new int[]{0, 0};
        int currentIndex = 1;
        for (int currentRadius = 1; currentRadius <= absRadius; ++currentRadius) {
            int x = currentRadius;
            int y = currentRadius;
            while (y > currentRadius * -1) {
                rotationalArray[currentIndex] = new int[]{x, --y};
                ++currentIndex;
            }
            while (x > currentRadius * -1) {
                rotationalArray[currentIndex] = new int[]{--x, y};
                ++currentIndex;
            }
            while (y < currentRadius) {
                rotationalArray[currentIndex] = new int[]{x, ++y};
                ++currentIndex;
            }
            while (x < currentRadius) {
                rotationalArray[currentIndex] = new int[]{++x, y};
                ++currentIndex;
            }
        }
        return rotationalArray;
    }

    public static Optional<Vec3> FindPortalExitPosition(EntityType<?> entityType, CollisionGetter collisionGetter, BlockPos portalPos) {
        Optional<Vec3> opt = PortalUtils.FindPortalExitPositionAtOffset(entityType, collisionGetter, portalPos, 0, true);
        if (opt.isPresent()) {
            return opt;
        }
        opt = PortalUtils.FindPortalExitPositionAtOffset(entityType, collisionGetter, portalPos, 1, true);
        if (opt.isPresent()) {
            return opt;
        }
        opt = PortalUtils.FindPortalExitPositionAtOffset(entityType, collisionGetter, portalPos, 2, true);
        return opt.isPresent() ? opt : PortalUtils.FindPortalExitPositionAtOffset(entityType, collisionGetter, portalPos, 0, false);
    }

    private static Optional<Vec3> FindPortalExitPositionAtOffset(EntityType<?> entityType, CollisionGetter collisionGetter, BlockPos portalPos, int yOffset, boolean preventDanger) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int[] offset : PORTAL_OFFSET_ARRAY) {
            mutableBlockPos.set(portalPos.getX() + offset[0], portalPos.getY() + yOffset, portalPos.getZ() + offset[1]);
            Vec3 vec3 = DismountHelper.findSafeDismountLocation(entityType, (CollisionGetter)collisionGetter, (BlockPos)mutableBlockPos, (boolean)preventDanger);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }
}

