/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.utility;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ToolTipBuilder {
    private static final int DEFAULT_UNSET = -1;
    private static final String CD_BASE_KEY = "item.toukun.util.cooldown";
    private static final String CD_SECONDS_KEY = "item.toukun.util.cooldown.seconds";
    private static final String CD_MINUTES_KEY = "item.toukun.util.cooldown.minutes";
    private static final String DAMAGE_BASE_KEY = "item.toukun.util.damage";
    private static final String DURABILITY_COST_KEY = "item.toukun.util.durability_cost";
    private static final String USE_TIME_KEY = "item.toukun.util.use_time";
    private String[] description = new String[0];
    private int cooldown = -1;
    private int durabilityCost = -1;
    private int useTime = -1;
    private float damage = -1.0f;

    public static Component getNewLineComponent() {
        return Component.literal((String)" ");
    }

    public static Component getDamageComponent(float damage) {
        return Component.translatable((String)DAMAGE_BASE_KEY, (Object[])new Object[]{Component.literal((String)String.valueOf(damage)).withStyle(ChatFormatting.RED)});
    }

    public static Component getCooldownComponent(int ticks) {
        return Component.translatable((String)CD_BASE_KEY, (Object[])new Object[]{ToolTipBuilder.getCooldownUnitsComponent(ticks)});
    }

    public static Component getDurabilityCostComponent(int durabilityCost) {
        return Component.translatable((String)DURABILITY_COST_KEY, (Object[])new Object[]{Component.literal((String)String.valueOf(durabilityCost)).withStyle(ChatFormatting.GREEN)});
    }

    private static Component getCooldownUnitsComponent(int ticks) {
        float seconds = ToolTipBuilder.convertTicksToSeconds(ticks);
        if (seconds >= 60.0f) {
            float minutes = ToolTipBuilder.convertSecondsToMinutes(seconds);
            return Component.translatable((String)CD_MINUTES_KEY, (Object[])new Object[]{Float.valueOf(minutes)}).withStyle(ChatFormatting.BLUE);
        }
        return Component.translatable((String)CD_SECONDS_KEY, (Object[])new Object[]{Float.valueOf(seconds)}).withStyle(ChatFormatting.BLUE);
    }

    private static Component getUseTimeComponent(int ticks) {
        float seconds = ToolTipBuilder.convertTicksToSeconds(ticks);
        return Component.translatable((String)USE_TIME_KEY, (Object[])new Object[]{Component.translatable((String)CD_SECONDS_KEY, (Object[])new Object[]{Float.valueOf(seconds)}).withStyle(ChatFormatting.BLUE)});
    }

    private static float convertTicksToSeconds(int ticks) {
        return (float)ticks / 20.0f;
    }

    private static float convertSecondsToMinutes(float seconds) {
        return seconds / 60.0f;
    }

    public void build(List<Component> componentList) {
        int currentLength = componentList.size();
        if (this.damage != -1.0f) {
            componentList.add(ToolTipBuilder.getDamageComponent(this.damage));
        }
        if (this.cooldown != -1) {
            componentList.add(ToolTipBuilder.getCooldownComponent(this.cooldown));
        }
        if (this.durabilityCost != -1) {
            componentList.add(ToolTipBuilder.getDurabilityCostComponent(this.durabilityCost));
        }
        if (this.useTime != -1) {
            componentList.add(ToolTipBuilder.getUseTimeComponent(this.useTime));
        }
        if (this.description.length != 0) {
            if (currentLength != componentList.size()) {
                componentList.add(ToolTipBuilder.getNewLineComponent());
            }
            for (String line : this.description) {
                componentList.add((Component)Component.translatable((String)line));
            }
        }
    }

    public ToolTipBuilder addCoolDown(int cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public ToolTipBuilder addDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public ToolTipBuilder addDescription(String[] description) {
        this.description = description;
        return this;
    }

    public ToolTipBuilder addDurabilityCost(int durabilityCost) {
        this.durabilityCost = durabilityCost;
        return this;
    }

    public ToolTipBuilder addUseTime(int useTime) {
        this.useTime = useTime;
        return this;
    }
}

