/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.world.feature;

import com.google.common.base.Suppliers;
import com.toukun.mymod.block.ModBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final Supplier<List<OreConfiguration.TargetBlockState>> OVERWORLD_SILVER_ORE = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)ModBlocks.SILVER_ORE.get()).defaultBlockState())));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_SILVER_KEY = ModConfiguredFeatures.registerKey("ore_silver");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_SILVER_BURIED_KEY = ModConfiguredFeatures.registerKey("ore_silver_buried");

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)new ResourceLocation("toukun", name));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        ModConfiguredFeatures.register(context, ORE_SILVER_KEY, Feature.ORE, new OreConfiguration(OVERWORLD_SILVER_ORE.get(), 4));
        ModConfiguredFeatures.register(context, ORE_SILVER_BURIED_KEY, Feature.ORE, new OreConfiguration(OVERWORLD_SILVER_ORE.get(), 8, 1.0f));
    }
}

