/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.world.feature;

import com.toukun.mymod.world.feature.ModConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> SILVER_ORE_KEY = ModPlacedFeatures.createKey("ore_silver");
    public static final ResourceKey<PlacedFeature> SILVER_ORE_BURIED_KEY = ModPlacedFeatures.createKey("ore_silver_buried");

    private static List<PlacementModifier> orePlacement(PlacementModifier frequencyPlacementModifier, PlacementModifier distributionPlacementModifier) {
        return List.of(frequencyPlacementModifier, InSquarePlacement.spread(), distributionPlacementModifier, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int chunkFrequency, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)chunkFrequency), placementModifier);
    }

    private static List<PlacementModifier> rareOrePlacement(int chunkAverage, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)chunkAverage), placementModifier);
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)new ResourceLocation("toukun", name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        ModPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, SILVER_ORE_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ORE_SILVER_KEY), ModPlacedFeatures.commonOrePlacement(100, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)16), (VerticalAnchor)VerticalAnchor.absolute((int)384))));
        ModPlacedFeatures.register(context, SILVER_ORE_BURIED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ORE_SILVER_BURIED_KEY), ModPlacedFeatures.commonOrePlacement(100, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)16), (VerticalAnchor)VerticalAnchor.absolute((int)384))));
    }
}

