/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.solute.mixins.bed;

import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2761;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5268;
import net.minecraft.class_5838;
import net.minecraft.server.MinecraftServer;
import nl.gjorgdy.solute.Solute;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class ServerWorldMixin {
    @Unique
    class_3218 serverWorld = (class_3218)this;
    @Shadow
    @Final
    private class_5838 field_28859;
    @Shadow
    @Final
    private MinecraftServer field_13959;
    @Shadow
    @Final
    private class_5268 field_24456;

    @Shadow
    protected abstract void method_23660();

    @Redirect(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/SleepManager;canSkipNight(I)Z"))
    private boolean injected(class_5838 instance, int percentage) {
        if (!Solute.CONFIG.bedModule.enabled) {
            return instance.method_33812(percentage);
        }
        boolean doDayLightCycle = this.serverWorld.method_64395().method_8355(class_1928.field_19396);
        boolean doWeatherCycle = this.serverWorld.method_64395().method_8355(class_1928.field_19406);
        int playersInWorld = this.serverWorld.method_18456().size();
        int playersSleeping = instance.method_33815();
        float playersSleepingPercentage = (float)playersSleeping / (float)playersInWorld;
        long worldTime = this.serverWorld.method_8532();
        if (playersSleeping >= 1) {
            if (doDayLightCycle && this.field_28859.method_33812((int)playersSleepingPercentage) || doWeatherCycle && this.serverWorld.method_8546()) {
                int timeDelta = this.getTimeDelta(playersSleepingPercentage);
                new Thread(() -> {
                    for (int i = 0; i < 10; ++i) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.setTime(worldTime + (long)timeDelta * (long)i);
                    }
                }).start();
                if (!doWeatherCycle) {
                    return false;
                }
                int thunderTime = this.field_24456.method_145();
                if (this.serverWorld.method_8546() && thunderTime > 0) {
                    int _thunderTime = Math.max(0, thunderTime - timeDelta * 2);
                    this.field_24456.method_173(_thunderTime);
                    if (_thunderTime == 0) {
                        this.field_24456.method_147(false);
                    }
                }
                int rainTime = this.field_24456.method_190();
                if (this.serverWorld.method_8419() && rainTime > 0) {
                    int _rainTime = Math.max(0, rainTime - timeDelta * 20);
                    this.field_24456.method_164(_rainTime);
                    if (_rainTime == 0) {
                        this.field_24456.method_157(false);
                    }
                }
            } else {
                this.method_23660();
            }
        }
        return false;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickTime(CallbackInfo ci) {
        if (!Solute.CONFIG.bedModule.enabled) {
            return;
        }
        long dayTime = this.serverWorld.method_8532() % 24000L;
        if (dayTime > 23600L) {
            int day = (int)(this.serverWorld.method_8510() / 24000L);
            String dayString = "-- Day " + day + " --";
            int i = (int)((dayTime - 23600L) / 5L);
            if (dayTime % 5L == 0L && i <= dayString.length()) {
                this.field_13959.method_3760().method_14571().forEach(player -> {
                    this.serverWorld.method_8396(null, player.method_24515(), (class_3414)class_3417.field_15204.comp_349(), class_3419.field_15256, (float)i, (float)i);
                    player.method_7353(class_2561.method_30163((String)dayString.substring(0, i)), true);
                });
            }
        }
    }

    @Unique
    private int getTimeDelta(float sleepingPercentage) {
        return Math.max(5, Math.round(10.0f * sleepingPercentage));
    }

    @Unique
    private void setTime(long newTime) {
        this.serverWorld.method_29199(newTime);
        this.field_13959.method_3760().method_14589((class_2596)new class_2761(this.field_24456.method_188(), this.field_24456.method_217(), true), this.serverWorld.method_27983());
    }
}

