/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.solute.modules;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5321;

public class Cobblestone {
    static final List<class_5321<class_1959>> MOSSY_BIOMES = List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_9440, class_1972.field_9420, class_1972.field_9454, class_1972.field_35113);
    static final List<class_5321<class_1959>> BADLAND_BIOMES = List.of(class_1972.field_9415, class_1972.field_9443, class_1972.field_35110);
    static final int CRYING_OBSIDIAN_POSSIBLE = 16;

    public static boolean fiftyFifty(class_1937 world) {
        return Cobblestone.chance(world, 1, 2);
    }

    public static boolean chance(class_1937 world, int favourable, int possible) {
        return Cobblestone.random(world, possible) <= favourable;
    }

    public static int random(class_1937 world, int possible) {
        return world.field_9229.method_43048(possible + 1);
    }

    public static class_2680 replaceCobblestone(class_1937 world, class_2338 pos, class_2680 block) {
        if (block.method_26204() == class_2246.field_10540) {
            return Cobblestone.generateObsidian(world);
        }
        if (block.method_26204() == class_2246.field_10445) {
            class_2248 under = world.method_8320(pos.method_10069(0, -1, 0)).method_26204();
            if (under == class_2246.field_10445) {
                return class_2246.field_10445.method_9564();
            }
            return Cobblestone.environmentBasedCobble(world, pos).method_9564();
        }
        return block;
    }

    public static class_2248 environmentBasedCobble(class_1937 world, class_2338 pos) {
        Optional biomeKeyOpt = world.method_23753(pos).method_40230();
        if (biomeKeyOpt.isEmpty()) {
            throw new RuntimeException("Could not find biome for position " + String.valueOf(pos));
        }
        class_5321 biomeKey = (class_5321)biomeKeyOpt.get();
        if (pos.method_10264() > 60 || Cobblestone.fiftyFifty(world) && pos.method_10264() > 50) {
            return Cobblestone.getCobblestoneForBiome(world, (class_5321<class_1959>)biomeKey);
        }
        if (pos.method_10264() < 0 || Cobblestone.fiftyFifty(world) && pos.method_10264() < 10) {
            return class_2246.field_29031;
        }
        if (world.method_27983().equals(class_1937.field_25181)) {
            return class_2246.field_10471;
        }
        return class_2246.field_10445;
    }

    public static class_2248 getCobblestoneForBiome(class_1937 world, class_5321<class_1959> biomeKey) {
        if (biomeKey == class_1972.field_9424) {
            return class_2246.field_9979;
        }
        if (BADLAND_BIOMES.contains(biomeKey)) {
            return class_2246.field_10344;
        }
        if (MOSSY_BIOMES.contains(biomeKey)) {
            return Cobblestone.chance(world, 1, 3) ? class_2246.field_9989 : class_2246.field_10445;
        }
        return class_2246.field_10445;
    }

    public static class_2680 replaceStone(class_1937 world, class_2338 pos) {
        class_2248 under = world.method_8320(pos.method_10069(0, -1, 0)).method_26204();
        if (under == class_2246.field_10340) {
            return class_2246.field_10340.method_9564();
        }
        return Cobblestone.environmentBasedStone(world, pos).method_9564();
    }

    public static class_2248 environmentBasedStone(class_1937 world, class_2338 pos) {
        Optional biomeKeyOpt = world.method_23753(pos).method_40230();
        if (biomeKeyOpt.isEmpty()) {
            return class_2246.field_10340;
        }
        int y = pos.method_10264();
        class_5321 biomeKey = (class_5321)biomeKeyOpt.get();
        if (y > 60 || Cobblestone.fiftyFifty(world) && pos.method_10264() > 50) {
            return Cobblestone.getStoneForBiome(world, (class_5321<class_1959>)biomeKey);
        }
        if (y > 50) {
            return Cobblestone.fiftyFifty(world) ? Cobblestone.getStoneForBiome(world, (class_5321<class_1959>)biomeKey) : Cobblestone.getStoneForUnderground(world);
        }
        if (y < 50 && y >= 10) {
            return Cobblestone.getStoneForUnderground(world);
        }
        if (y < 10 && y >= 0) {
            return Cobblestone.fiftyFifty(world) ? class_2246.field_28888 : Cobblestone.getStoneForUnderground(world);
        }
        if (y < 0) {
            return class_2246.field_28888;
        }
        if (world.method_27983().equals(class_1937.field_25181)) {
            return class_2246.field_10471;
        }
        return class_2246.field_10340;
    }

    public static class_2248 getStoneForBiome(class_1937 world, class_5321<class_1959> biomeKey) {
        if (biomeKey == class_1972.field_9424) {
            return class_2246.field_10467;
        }
        if (BADLAND_BIOMES.contains(biomeKey)) {
            return Cobblestone.randomBlock(world, Map.of(class_2246.field_10483, 2, class_2246.field_10415, 3, class_2246.field_10328, 1, class_2246.field_10184, 1, class_2246.field_10123, 1, class_2246.field_10611, 1, class_2246.field_10143, 1));
        }
        if (MOSSY_BIOMES.contains(biomeKey)) {
            return Cobblestone.chance(world, 1, 3) ? class_2246.field_9989 : class_2246.field_10445;
        }
        return class_2246.field_10445;
    }

    public static class_2248 getStoneForUnderground(class_1937 world) {
        return Cobblestone.randomBlock(world, Map.of(class_2246.field_10115, 2, class_2246.field_10508, 2, class_2246.field_10474, 2, class_2246.field_10340, 4));
    }

    private static class_2248 randomBlock(class_1937 world, Map<class_2248, Integer> blocks) {
        int r = Cobblestone.random(world, 10);
        int c = 0;
        for (Map.Entry<class_2248, Integer> entry : blocks.entrySet()) {
            if (r >= (c += entry.getValue().intValue())) continue;
            return entry.getKey();
        }
        return (class_2248)blocks.keySet().toArray()[blocks.size() - 1];
    }

    private static class_2680 generateObsidian(class_1937 world) {
        if (Cobblestone.chance(world, 1, 16)) {
            return class_2246.field_22423.method_9564();
        }
        return class_2246.field_10540.method_9564();
    }
}

