/*
 * Decompiled with CFR 0.152.
 */
package com.raggle;

import com.raggle.HalfDream;
import com.raggle.api.DreamChunkComponent;
import com.raggle.api.DreamEntityComponent;
import com.raggle.api.DreamPlayerComponent;
import com.raggle.registry.FaeComponentRegistry;
import com.raggle.util.DreamState;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import org.jetbrains.annotations.Nullable;

public class FaeUtil {
    public static DreamState getDreamState(class_1297 e) {
        Optional op = FaeComponentRegistry.DREAM_ENTITY.maybeGet((Object)e);
        if (op.isEmpty() || ((DreamEntityComponent)op.get()).getDream() == null) {
            return DreamState.AWAKE;
        }
        return ((DreamEntityComponent)op.get()).getDream();
    }

    public static void setDream(class_1297 e, DreamState b) {
        Optional op = FaeComponentRegistry.DREAM_ENTITY.maybeGet((Object)e);
        if (op.isEmpty()) {
            return;
        }
        ((DreamEntityComponent)op.get()).setDream(b);
    }

    public static void toggleDream(class_1297 e) {
        DreamState dream = FaeUtil.getDreamState(e);
        if (dream == DreamState.AWAKE) {
            FaeUtil.setDream(e, DreamState.ASLEEP);
        } else if (dream == DreamState.ASLEEP) {
            FaeUtil.setDream(e, DreamState.AWAKE);
        }
    }

    public static boolean setDreamAir(class_2338 pos, boolean append, class_1922 world) {
        return FaeUtil.setComponentPos(pos, append, world, FaeComponentRegistry.DREAM_AIR);
    }

    public static boolean setDreamBlock(class_2338 pos, boolean append, class_1922 world) {
        return FaeUtil.setComponentPos(pos, append, world, FaeComponentRegistry.DREAM_BLOCKS);
    }

    public static boolean isDreamAir(class_2338 pos, class_1922 world) {
        return FaeUtil.componentContainsPos(pos, world, FaeComponentRegistry.DREAM_AIR);
    }

    public static boolean isDreamBlock(class_2338 pos, class_1922 world) {
        return FaeUtil.componentContainsPos(pos, world, FaeComponentRegistry.DREAM_BLOCKS);
    }

    private static boolean setComponentPos(class_2338 pos, boolean append, class_1922 world, ComponentKey<DreamChunkComponent> key) {
        DreamChunkComponent dreamChunk = FaeUtil.getDreamChunkComponent(pos, world, key);
        if (dreamChunk != null) {
            if (append) {
                HalfDream.LOGGER.debug("Adding " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + " to " + String.valueOf(key));
                return dreamChunk.addPosToList(pos);
            }
            HalfDream.LOGGER.debug("Removing " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + " to " + String.valueOf(key));
            return dreamChunk.removePosFromList(pos);
        }
        return false;
    }

    public static boolean componentContainsPos(class_2338 pos, class_1922 world, ComponentKey<DreamChunkComponent> key) {
        DreamChunkComponent dreamChunk = FaeUtil.getDreamChunkComponent(pos, world, key);
        if (dreamChunk != null) {
            return dreamChunk.contains(pos);
        }
        return false;
    }

    @Nullable
    private static DreamChunkComponent getDreamChunkComponent(class_2338 pos, @Nullable class_1922 world, ComponentKey<DreamChunkComponent> key) {
        class_2791 chunk = null;
        if (world instanceof class_1937) {
            class_1937 w = (class_1937)world;
            chunk = w.method_22350(pos);
        } else if (world instanceof class_2791) {
            class_2791 c;
            chunk = c = (class_2791)world;
        }
        Optional op = key.maybeGet(chunk);
        if (op.isEmpty()) {
            return null;
        }
        return (DreamChunkComponent)op.get();
    }

    public static boolean queueDreamBlock(class_2338 pos, class_1937 world) {
        DreamChunkComponent dreamChunk = FaeUtil.getDreamChunkComponent(pos, (class_1922)world, FaeComponentRegistry.DREAM_BLOCKS);
        if (dreamChunk != null) {
            return dreamChunk.addPosToQueue(pos);
        }
        return false;
    }

    public static boolean pushDreamBlock(class_2338 pos, class_1937 world) {
        DreamChunkComponent dreamChunk = FaeUtil.getDreamChunkComponent(pos, (class_1922)world, FaeComponentRegistry.DREAM_BLOCKS);
        if (dreamChunk != null) {
            return dreamChunk.pushPosFromQueue(pos);
        }
        return false;
    }

    public static boolean canInteract(class_1297 e1, class_1297 e2) {
        DreamState d1 = FaeUtil.getDreamState(e1);
        DreamState d2 = FaeUtil.getDreamState(e2);
        return d1 == DreamState.DUAL || d2 == DreamState.DUAL || d1 == d2;
    }

    public static boolean canInteract(class_1297 entity, class_2338 pos, class_1922 world) {
        DreamState dream = FaeUtil.getDreamState(entity);
        if (dream == DreamState.ASLEEP) {
            return !FaeUtil.isDreamAir(pos, world);
        }
        if (dream == DreamState.AWAKE) {
            return !FaeUtil.isDreamBlock(pos, world);
        }
        return true;
    }

    public static boolean isInterloped(class_1657 player) {
        Optional op = FaeComponentRegistry.DREAM_PLAYER.maybeGet((Object)player);
        if (op.isEmpty()) {
            return false;
        }
        return ((DreamPlayerComponent)op.get()).isInterloped();
    }

    public static boolean setInterlope(class_1657 player, boolean value) {
        Optional op = FaeComponentRegistry.DREAM_PLAYER.maybeGet((Object)player);
        if (op.isEmpty()) {
            return false;
        }
        ((DreamPlayerComponent)op.get()).setInterlope(value);
        return true;
    }
}

