/*
 * Decompiled with CFR 0.152.
 */
package com.raggle.client.sequence;

import com.raggle.FaeUtil;
import com.raggle.client.sequence.DreamSequence;
import com.raggle.client.sequence.FogEffect;
import com.raggle.util.DreamState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class SequenceManager {
    private static DreamSequence dreamSequence;
    private static FogEffect fogEffect;

    public static void tick(class_310 client) {
        if (client.method_1493()) {
            return;
        }
        if (fogEffect != null) {
            fogEffect.tick(client);
            if (SequenceManager.fogEffect.finished) {
                fogEffect.stop();
                fogEffect = null;
            }
        } else if (FaeUtil.getDreamState((class_1297)client.field_1724) == DreamState.ASLEEP) {
            SequenceManager.setFogEffect(FogEffect.DREAM_FOG);
        }
        if (SequenceManager.hasSequence() && client.field_1724 != null) {
            dreamSequence.tick();
            if (SequenceManager.dreamSequence.finished) {
                dreamSequence.stop();
                dreamSequence = null;
            }
        }
    }

    public static void render(class_332 g, float tickDelta) {
        if (SequenceManager.hasSequence()) {
            dreamSequence.render(g, tickDelta);
        }
    }

    public static void start(DreamSequence newSequence) {
        if (!SequenceManager.hasSequence()) {
            dreamSequence = newSequence;
            dreamSequence.start();
        }
    }

    public static boolean hasSequence() {
        return dreamSequence != null;
    }

    public static DreamSequence getSequence() {
        return dreamSequence;
    }

    public static boolean hasFogEffect() {
        return fogEffect != null;
    }

    public static void setFogEffect(FogEffect effect) {
        fogEffect = effect;
        fogEffect.start();
    }

    public static FogEffect getFogEffect() {
        return fogEffect;
    }

    public static boolean isCurrentSequenceImportant() {
        if (!SequenceManager.hasSequence()) {
            return false;
        }
        return dreamSequence.isSequenceImportant();
    }
}

