/*
 * Decompiled with CFR 0.152.
 */
package com.raggle.client.sequence;

import com.raggle.client.sequence.FogEffect;
import com.raggle.networking.FaeC2S;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SkeletonCircleFogEffect
extends FogEffect {
    private int totalLength = 1200;
    private int progress;

    public SkeletonCircleFogEffect() {
        this.red = 0.423f;
        this.green = 0.634f;
        this.blue = 0.785f;
        this.fogEnd = 24.0f;
    }

    @Override
    public void tick(class_310 client) {
        this.progress = !this.cancelled ? ++this.progress : --this.progress;
        if (this.progress > this.totalLength + 244) {
            this.finished = true;
        } else if (this.progress < 0) {
            this.finished = true;
        }
        if (this.progress < this.totalLength / 2) {
            this.setRedColors();
        } else if (this.progress < this.totalLength) {
            this.setGBColors();
        } else if (this.progress > this.totalLength + 120) {
            this.setBlackColors();
        }
    }

    @Override
    public void stop() {
        class_2540 buf = PacketByteBufs.create();
        ClientPlayNetworking.send((class_2960)FaeC2S.DEEP_DREAM, (class_2540)buf);
    }

    private void setRedColors() {
        float scale = 1.0f - (float)this.progress * 2.0f / (float)this.totalLength;
        this.red = 0.785f - 0.36200002f * scale;
    }

    private void setGBColors() {
        float scale = 2.0f - (float)this.progress * 2.0f / (float)this.totalLength;
        this.green = 0.634f * scale;
        this.blue = 0.785f * scale;
        this.fogEnd = 12.0f * scale + 12.0f;
    }

    private void setBlackColors() {
        float scale = this.progress < this.totalLength + 240 ? 1.0f - ((float)this.progress - (float)this.totalLength - 120.0f) / 120.0f : 0.0f;
        this.red = 0.785f * scale;
        this.fogEnd = 22.0f * scale + 2.0f;
    }
}

