/*
 * Decompiled with CFR 0.152.
 */
package com.raggle.component;

import com.raggle.api.DreamChunkComponent;
import com.raggle.registry.FaeComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.ArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2791;
import net.minecraft.class_3222;

public class DreamChunkComponentImpl
implements DreamChunkComponent,
AutoSyncedComponent {
    private final class_2791 provider;
    private ArrayList<Long> posList;
    private ArrayList<Long> posQueue;
    private long renderPos;

    public DreamChunkComponentImpl(class_2791 chunk) {
        this.provider = chunk;
        this.posList = new ArrayList();
        this.posQueue = new ArrayList();
    }

    public void readFromNbt(class_2487 tag) {
        this.posList.clear();
        for (long entry : tag.method_10565("dreampos")) {
            this.addPosToList(class_2338.method_10092((long)entry));
        }
    }

    public void writeToNbt(class_2487 tag) {
        long[] posList = new long[this.posList.size()];
        for (int i = 0; i < posList.length; ++i) {
            posList[i] = this.posList.get(i);
        }
        tag.method_10564("dreampos", posList);
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        class_2487 tag = new class_2487();
        this.writeToNbt(tag);
        tag.method_10544("renderpos", this.renderPos);
        buf.method_10794(tag);
        this.provider.method_12008(true);
    }

    public void applySyncPacket(class_2540 buf) {
        class_2487 tag = buf.method_10798();
        if (tag != null) {
            this.readFromNbt(tag);
            this.renderPos = tag.method_10537("renderpos");
            this.provider.method_12008(true);
        }
    }

    @Override
    public boolean contains(class_2338 pos) {
        return !this.posList.isEmpty() && this.posList.contains(pos.method_10063());
    }

    @Override
    public boolean addPosToList(class_2338 pos) {
        if (!this.posList.contains(pos.method_10063())) {
            this.posList.add(pos.method_10063());
            this.renderPos = pos.method_10063();
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public boolean removePosFromList(class_2338 pos) {
        if (this.posList.remove(pos.method_10063())) {
            this.renderPos = pos.method_10063();
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public boolean addPosToQueue(class_2338 pos) {
        if (!this.posQueue.contains(pos.method_10063())) {
            this.posQueue.add(pos.method_10063());
            return true;
        }
        return false;
    }

    @Override
    public boolean pushPosFromQueue(class_2338 pos) {
        if (this.posQueue.remove(pos.method_10063())) {
            return this.addPosToList(pos);
        }
        return false;
    }

    @Override
    public int clear() {
        int count = this.posList.size();
        this.posList.clear();
        this.sync();
        return count;
    }

    @Override
    public long getRenderPos() {
        long pos = this.renderPos;
        this.renderPos = 0L;
        return pos;
    }

    private void sync() {
        FaeComponentRegistry.DREAM_AIR.sync((Object)this.provider);
        FaeComponentRegistry.DREAM_BLOCKS.sync((Object)this.provider);
    }
}

