/*
 * Decompiled with CFR 0.152.
 */
package com.raggle.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.raggle.FaeUtil;
import com.raggle.api.DreamChunkComponent;
import com.raggle.registry.FaeComponentRegistry;
import com.raggle.registry.FaeItemRegistry;
import com.raggle.util.DreamState;
import dev.onyxstudios.cca.api.v3.entity.PlayerCopyCallback;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_55;
import net.minecraft.class_7157;
import net.minecraft.class_79;
import net.minecraft.class_83;
import org.jetbrains.annotations.Nullable;

public class FaeEventRegistry {
    public static void init() {
        PlayerCopyCallback.EVENT.register(FaeEventRegistry::afterRespawn);
        PlayerBlockBreakEvents.BEFORE.register(FaeEventRegistry::beforeBlockBreak);
        UseBlockCallback.EVENT.register(FaeEventRegistry::onBlockUse);
        CommandRegistrationCallback.EVENT.register(FaeEventRegistry::dreamstate);
        CommandRegistrationCallback.EVENT.register(FaeEventRegistry::dreamclear);
        CommandRegistrationCallback.EVENT.register(FaeEventRegistry::interlope);
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            class_2960 fishingID = new class_2960("gameplay/fishing/fish");
            if (source.isBuiltin() && fishingID.equals((Object)id)) {
                class_55.class_56 poolBuilder = class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)new class_2960("half_dream", "fishing_chest")));
                tableBuilder.method_336(poolBuilder);
            }
        });
    }

    private static void afterRespawn(class_3222 copy, class_3222 original, boolean wasDeath) {
    }

    private static boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        DreamState player_dream = FaeUtil.getDreamState((class_1297)player);
        if (player_dream == DreamState.ASLEEP && !FaeUtil.isDreamBlock(pos, (class_1922)world)) {
            class_1542 dream_resin = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), new class_1799((class_1935)FaeItemRegistry.DREAM_RESIN));
            world.method_8649((class_1297)dream_resin);
            dream_resin.method_6988();
            FaeUtil.setDream((class_1297)dream_resin, DreamState.ASLEEP);
            FaeUtil.setDreamAir(pos, true, (class_1922)world);
            return false;
        }
        return true;
    }

    private static class_1269 onBlockUse(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        Iterable stacks = player.method_5877();
        DreamState dreamState = FaeUtil.getDreamState((class_1297)player);
        for (class_1799 itemStack : stacks) {
            class_1750 itemContext = new class_1750(world, player, hand, itemStack, hitResult);
            if (!itemContext.method_7716()) continue;
            if (dreamState == DreamState.ASLEEP) {
                FaeUtil.queueDreamBlock(itemContext.method_8037(), world);
                break;
            }
            if (dreamState != DreamState.AWAKE || !FaeUtil.isDreamBlock(itemContext.method_8037(), (class_1922)world)) continue;
            world.method_8501(itemContext.method_8037(), class_2246.field_10124.method_9564());
            break;
        }
        return class_1269.field_5811;
    }

    private static LiteralCommandNode<class_2168> dreamstate(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        return dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dreamstate").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            byte dreamLevel = (byte)IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            if (dreamLevel < 0 || dreamLevel > 2) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Value must be 0, 1, or 2"));
                return -1;
            }
            FaeUtil.setDream((class_1297)((class_2168)context.getSource()).method_44023(), DreamState.fromByte(dreamLevel));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Set dream to %s".formatted(new Object[]{DreamState.fromByte(dreamLevel)})), false);
            return 1;
        })).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            byte dreamLevel = (byte)IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (dreamLevel < 0 || dreamLevel > 2) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Value must be 0, 1, or 2"));
                return -1;
            }
            FaeUtil.setDream(entity, DreamState.fromByte(dreamLevel));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Set dream of %s to %s".formatted(new Object[]{entity.method_5477().getString(), DreamState.fromByte(dreamLevel)})), true);
            return 1;
        }))));
    }

    private static LiteralCommandNode<class_2168> dreamclear(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        return dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dreamclear").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_9211();
            class_2791 chunk = ((class_2168)context.getSource()).method_44023().method_37908().method_22350(((class_2168)context.getSource()).method_44023().method_24515());
            int air_count = ((DreamChunkComponent)FaeComponentRegistry.DREAM_AIR.get((Object)chunk)).clear();
            int block_count = ((DreamChunkComponent)FaeComponentRegistry.DREAM_BLOCKS.get((Object)chunk)).clear();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Deleted " + air_count + " dream air and " + block_count + " dream blocks")), false);
            return 1;
        }));
    }

    private static LiteralCommandNode<class_2168> interlope(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        return dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"interlope").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean value = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            FaeUtil.setInterlope((class_1657)((class_2168)context.getSource()).method_44023(), value);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Set interlope to %s".formatted(value)), false);
            return 1;
        })));
    }
}

