/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.unmapped.C_1189578;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_5058702;
import net.minecraft.unmapped.C_5318159;
import net.minecraft.unmapped.C_5362195;
import net.minecraft.unmapped.C_5578771;
import net.minecraft.unmapped.C_5636518;
import net.minecraft.unmapped.C_5693434;
import net.minecraft.unmapped.C_6684392;
import net.minecraft.unmapped.C_7035249;
import net.minecraft.unmapped.C_8052742;
import net.minecraft.unmapped.C_9785392;

final class NBTConverter {
    private NBTConverter() {
    }

    public static C_3225627 toNative(Tag tag) {
        if (tag instanceof IntArrayTag) {
            return NBTConverter.toNative((IntArrayTag)tag);
        }
        if (tag instanceof ListTag) {
            return NBTConverter.toNative((ListTag)tag);
        }
        if (tag instanceof LongTag) {
            return NBTConverter.toNative((LongTag)tag);
        }
        if (tag instanceof StringTag) {
            return NBTConverter.toNative((StringTag)tag);
        }
        if (tag instanceof IntTag) {
            return NBTConverter.toNative((IntTag)tag);
        }
        if (tag instanceof ByteTag) {
            return NBTConverter.toNative((ByteTag)tag);
        }
        if (tag instanceof ByteArrayTag) {
            return NBTConverter.toNative((ByteArrayTag)tag);
        }
        if (tag instanceof CompoundTag) {
            return NBTConverter.toNative((CompoundTag)tag);
        }
        if (tag instanceof FloatTag) {
            return NBTConverter.toNative((FloatTag)tag);
        }
        if (tag instanceof ShortTag) {
            return NBTConverter.toNative((ShortTag)tag);
        }
        if (tag instanceof DoubleTag) {
            return NBTConverter.toNative((DoubleTag)tag);
        }
        throw new IllegalArgumentException("Can't convert tag of type " + tag.getClass().getCanonicalName());
    }

    public static C_7035249 toNative(IntArrayTag tag) {
        int[] value = tag.getValue();
        return new C_7035249(Arrays.copyOf(value, value.length));
    }

    public static C_5693434 toNative(ListTag tag) {
        C_5693434 list = new C_5693434();
        for (Tag child : tag.getValue()) {
            if (child instanceof EndTag) continue;
            list.m_0728373(NBTConverter.toNative(child));
        }
        return list;
    }

    public static C_9785392 toNative(LongTag tag) {
        return new C_9785392(tag.getValue().longValue());
    }

    public static C_5362195 toNative(StringTag tag) {
        return new C_5362195(tag.getValue());
    }

    public static C_8052742 toNative(IntTag tag) {
        return new C_8052742(tag.getValue().intValue());
    }

    public static C_5318159 toNative(ByteTag tag) {
        return new C_5318159(tag.getValue().byteValue());
    }

    public static C_6684392 toNative(ByteArrayTag tag) {
        byte[] value = tag.getValue();
        return new C_6684392(Arrays.copyOf(value, value.length));
    }

    public static C_2018497 toNative(CompoundTag tag) {
        C_2018497 compound = new C_2018497();
        for (Map.Entry child : tag.getValue().entrySet()) {
            compound.m_2972230((String)child.getKey(), NBTConverter.toNative((Tag)child.getValue()));
        }
        return compound;
    }

    public static C_5636518 toNative(FloatTag tag) {
        return new C_5636518(tag.getValue().floatValue());
    }

    public static C_5578771 toNative(ShortTag tag) {
        return new C_5578771(tag.getValue().shortValue());
    }

    public static C_5058702 toNative(DoubleTag tag) {
        return new C_5058702(tag.getValue().doubleValue());
    }

    public static Tag fromNative(C_3225627 other) {
        if (other instanceof C_7035249) {
            return NBTConverter.fromNative((C_7035249)other);
        }
        if (other instanceof C_5693434) {
            return NBTConverter.fromNative((C_5693434)other);
        }
        if (other instanceof C_1189578) {
            return NBTConverter.fromNative((C_1189578)other);
        }
        if (other instanceof C_9785392) {
            return NBTConverter.fromNative((C_9785392)other);
        }
        if (other instanceof C_5362195) {
            return NBTConverter.fromNative((C_5362195)other);
        }
        if (other instanceof C_8052742) {
            return NBTConverter.fromNative((C_8052742)other);
        }
        if (other instanceof C_5318159) {
            return NBTConverter.fromNative((C_5318159)other);
        }
        if (other instanceof C_6684392) {
            return NBTConverter.fromNative((C_6684392)other);
        }
        if (other instanceof C_2018497) {
            return NBTConverter.fromNative((C_2018497)other);
        }
        if (other instanceof C_5636518) {
            return NBTConverter.fromNative((C_5636518)other);
        }
        if (other instanceof C_5578771) {
            return NBTConverter.fromNative((C_5578771)other);
        }
        if (other instanceof C_5058702) {
            return NBTConverter.fromNative((C_5058702)other);
        }
        throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
    }

    public static IntArrayTag fromNative(C_7035249 other) {
        int[] value = other.m_9813732();
        return new IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public static ListTag fromNative(C_5693434 other) {
        other = (C_5693434)other.m_8718046();
        ArrayList<Tag> list = new ArrayList<Tag>();
        Class listClass = StringTag.class;
        int tags = other.m_8051737();
        for (int i = 0; i < tags; ++i) {
            Tag child = NBTConverter.fromNative(other.m_8443996(0));
            list.add(child);
            listClass = child.getClass();
        }
        return new ListTag(listClass, list);
    }

    public static EndTag fromNative(C_1189578 other) {
        return new EndTag();
    }

    public static LongTag fromNative(C_9785392 other) {
        return new LongTag(other.m_7940320());
    }

    public static StringTag fromNative(C_5362195 other) {
        return new StringTag(other.m_1266443());
    }

    public static IntTag fromNative(C_8052742 other) {
        return new IntTag(other.m_6614801());
    }

    public static ByteTag fromNative(C_5318159 other) {
        return new ByteTag(other.m_7821962());
    }

    public static ByteArrayTag fromNative(C_6684392 other) {
        byte[] value = other.m_7659981();
        return new ByteArrayTag(Arrays.copyOf(value, value.length));
    }

    public static CompoundTag fromNative(C_2018497 other) {
        Set tags = other.m_5340812();
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        for (String tagName : tags) {
            map.put(tagName, NBTConverter.fromNative(other.m_9800739(tagName)));
        }
        return new CompoundTag(map);
    }

    public static FloatTag fromNative(C_5636518 other) {
        return new FloatTag(other.m_3823164());
    }

    public static ShortTag fromNative(C_5578771 other) {
        return new ShortTag(other.m_6301176());
    }

    public static DoubleTag fromNative(C_5058702 other) {
        return new DoubleTag(other.m_9704478());
    }
}

