/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.unmapped.C_3292284;
import webridge.WorldEditBridge;

class ThreadSafeCache {
    private static final long REFRESH_DELAY = 30000L;
    private static final ThreadSafeCache INSTANCE = new ThreadSafeCache();
    private Set<UUID> onlineIds = Collections.emptySet();
    private long lastRefresh = 0L;

    ThreadSafeCache() {
    }

    public Set<UUID> getOnlineIds() {
        return this.onlineIds;
    }

    public void tickStart() {
        long now = System.currentTimeMillis();
        if (now - this.lastRefresh > 30000L) {
            HashSet<UUID> onlineIds = new HashSet<UUID>();
            for (Object object : WorldEditBridge.minecraftServer.m_8526012().m_8800532()) {
                if (object == null) continue;
                C_3292284 player = (C_3292284)object;
                onlineIds.add(player.m_2013188());
            }
            this.onlineIds = new CopyOnWriteArraySet<UUID>(onlineIds);
            this.lastRefresh = now;
        }
    }

    public static ThreadSafeCache getInstance() {
        return INSTANCE;
    }
}

