/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_3622326;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_8052742;

final class TileEntityUtils {
    private TileEntityUtils() {
    }

    private static C_2018497 updateForSet(C_2018497 tag, Vector position) {
        Preconditions.checkNotNull((Object)tag);
        Preconditions.checkNotNull((Object)position);
        tag.m_2972230("x", (C_3225627)new C_8052742(position.getBlockX()));
        tag.m_2972230("y", (C_3225627)new C_8052742(position.getBlockY()));
        tag.m_2972230("z", (C_3225627)new C_8052742(position.getBlockZ()));
        return tag;
    }

    static void setTileEntity(C_5553933 world, Vector position, Class<? extends C_3622326> clazz, @Nullable C_2018497 tag) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull(clazz);
        C_3622326 tileEntity = TileEntityUtils.constructTileEntity(world, position, clazz);
        if (tileEntity == null) {
            return;
        }
        if (tag != null) {
            TileEntityUtils.updateForSet(tag, position);
            tileEntity.m_4740132(tag);
        }
        world.m_8905645(new C_3674802(position.getBlockX(), position.getBlockY(), position.getBlockZ()), tileEntity);
    }

    static void setTileEntity(C_5553933 world, Vector position, @Nullable C_2018497 tag) {
        if (tag != null) {
            TileEntityUtils.updateForSet(tag, position);
            C_3622326 tileEntity = C_3622326.m_8878179((C_5553933)world, (C_2018497)tag);
            if (tileEntity != null) {
                world.m_8905645(new C_3674802(position.getBlockX(), position.getBlockY(), position.getBlockZ()), tileEntity);
            }
        }
    }

    @Nullable
    static C_3622326 constructTileEntity(C_5553933 world, Vector position, Class<? extends C_3622326> clazz) {
        C_3622326 genericTE;
        Constructor<? extends C_3622326> baseConstructor;
        try {
            baseConstructor = clazz.getConstructor(new Class[0]);
        }
        catch (Throwable e) {
            return null;
        }
        try {
            genericTE = baseConstructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
        return genericTE;
    }
}

