/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import com.google.common.collect.HashBiMap;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.biome.BiomeData;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.unmapped.C_6928498;

class VanillaBiomeRegistry
implements BiomeRegistry {
    private static Map<Integer, C_6928498> biomes = Collections.emptyMap();
    private static Map<Integer, BiomeData> biomeData = Collections.emptyMap();

    VanillaBiomeRegistry() {
    }

    @Nullable
    public BaseBiome createFromId(int id) {
        return new BaseBiome(id);
    }

    public List<BaseBiome> getBiomes() {
        ArrayList<BaseBiome> list = new ArrayList<BaseBiome>();
        for (int biome : biomes.keySet()) {
            list.add(new BaseBiome(biome));
        }
        return list;
    }

    @Nullable
    public BiomeData getData(BaseBiome biome) {
        return biomeData.get(biome.getId());
    }

    static void populate() {
        HashBiMap biomes = HashBiMap.create();
        HashMap<Integer, BiomeData> biomeData = new HashMap<Integer, BiomeData>();
        for (C_6928498 biome : C_6928498.f_8917085) {
            if (biome == null || biomes.containsValue(biome)) continue;
            biomes.put(C_6928498.m_7889664((C_6928498)biome), biome);
            biomeData.put(C_6928498.m_7889664((C_6928498)biome), new CarpetBiomeData(biome));
        }
        VanillaBiomeRegistry.biomes = biomes;
        VanillaBiomeRegistry.biomeData = biomeData;
    }

    private static class CarpetBiomeData
    implements BiomeData {
        private final String name;

        private CarpetBiomeData(C_6928498 biome) {
            this.name = CarpetBiomeData.getName(biome);
        }

        private static String getName(C_6928498 biome) {
            Field nameField = null;
            for (Field field : C_6928498.class.getDeclaredFields()) {
                if (field.getType() != String.class) continue;
                nameField = field;
                break;
            }
            nameField.setAccessible(true);
            try {
                return (String)nameField.get(biome);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

