/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.metadata.EntityType;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.NullWorld;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_8252988;
import webridge.NBTConverter;
import webridge.VanillaAdapter;
import webridge.VanillaEntityType;

class VanillaEntity
implements Entity {
    private final WeakReference<C_0539808> entityRef;

    VanillaEntity(C_0539808 entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entityRef = new WeakReference<C_0539808>(entity);
    }

    public BaseEntity getState() {
        C_0539808 entity = (C_0539808)this.entityRef.get();
        if (entity != null) {
            String id = C_8252988.m_9561348((C_0539808)entity);
            if (id != null) {
                C_2018497 tag = new C_2018497();
                entity.m_7690388(tag);
                return new BaseEntity(id, NBTConverter.fromNative(tag));
            }
            return null;
        }
        return null;
    }

    public Location getLocation() {
        C_0539808 entity = (C_0539808)this.entityRef.get();
        if (entity != null) {
            Vector position = new Vector(entity.f_6638345, entity.f_1187082, entity.f_9103758);
            float yaw = entity.f_7165431;
            float pitch = entity.f_0243146;
            return new Location((Extent)VanillaAdapter.adapt(entity.f_4703454), position, yaw, pitch);
        }
        return new Location((Extent)NullWorld.getInstance());
    }

    public Extent getExtent() {
        C_0539808 entity = (C_0539808)this.entityRef.get();
        if (entity != null) {
            return VanillaAdapter.adapt(entity.f_4703454);
        }
        return NullWorld.getInstance();
    }

    public boolean remove() {
        C_0539808 entity = (C_0539808)this.entityRef.get();
        if (entity != null) {
            entity.m_3247694();
        }
        return true;
    }

    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        C_0539808 entity = (C_0539808)this.entityRef.get();
        if (entity != null) {
            if (EntityType.class.isAssignableFrom(cls)) {
                return (T)new VanillaEntityType(entity);
            }
            return null;
        }
        return null;
    }
}

