/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.AbstractPlatform;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.MultiUserPlatform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.util.PropertiesConfiguration;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_3755722;
import net.minecraft.unmapped.C_3865296;
import net.minecraft.unmapped.C_5335372;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_8252988;
import net.minecraft.unmapped.C_8433864;
import net.minecraft.unmapped.C_9992501;
import webridge.CommandWrapper;
import webridge.VanillaPlayer;
import webridge.VanillaWorld;
import webridge.VanillaWorldEdit;
import webridge.WorldEditBridge;

class VanillaPlatform
extends AbstractPlatform
implements MultiUserPlatform {
    private final VanillaWorldEdit mod;
    private final MinecraftServer server;
    private boolean hookingEvents = false;

    VanillaPlatform(VanillaWorldEdit mod) {
        this.mod = mod;
        this.server = WorldEditBridge.minecraftServer;
    }

    boolean isHookingEvents() {
        return this.hookingEvents;
    }

    public int resolveItem(String name) {
        C_1241852 block;
        if (name == null) {
            return 0;
        }
        int index = name.indexOf(58);
        if (index != -1 && index != 0 && index != name.length() - 1 && (block = C_1241852.m_3638151((String)name)) != null) {
            return C_1241852.m_8163480((C_1241852)block);
        }
        for (Object itemObj : C_3755722.f_8921864) {
            C_3755722 item = (C_3755722)itemObj;
            if (item == null || item.m_8870654() == null) continue;
            if (item.m_8870654().startsWith("item.") && item.m_8870654().equalsIgnoreCase("item." + name)) {
                return C_3755722.m_1350352((C_3755722)item);
            }
            if (item.m_8870654().startsWith("tile.") && item.m_8870654().equalsIgnoreCase("tile." + name)) {
                return C_3755722.m_1350352((C_3755722)item);
            }
            if (!item.m_8870654().equalsIgnoreCase(name)) continue;
            return C_3755722.m_1350352((C_3755722)item);
        }
        return 0;
    }

    public boolean isValidMobType(String type) {
        return C_8252988.m_5040729((C_0561170)new C_0561170(type));
    }

    public void reload() {
    }

    public int schedule(long delay, long period, Runnable task) {
        return -1;
    }

    public List<? extends World> getWorlds() {
        List<C_3865296> worlds = Arrays.asList(this.server.f_0746062);
        ArrayList<VanillaWorld> ret = new ArrayList<VanillaWorld>(worlds.size());
        for (C_3865296 world : worlds) {
            ret.add(new VanillaWorld((C_5553933)world));
        }
        return ret;
    }

    @Nullable
    public Player matchPlayer(Player player) {
        if (player instanceof VanillaPlayer) {
            return player;
        }
        C_3292284 entity = this.server.m_8526012().m_4343635(player.getName());
        return entity != null ? new VanillaPlayer(entity) : null;
    }

    @Nullable
    public World matchWorld(World world) {
        if (world instanceof VanillaWorld) {
            return world;
        }
        for (C_3865296 ws : this.server.f_0746062) {
            if (!ws.m_6536808().m_3688463().equals(world.getName())) continue;
            return new VanillaWorld((C_5553933)ws);
        }
        return null;
    }

    public void registerCommands(Dispatcher dispatcher) {
        if (this.server == null) {
            return;
        }
        C_5335372 mcMan = (C_5335372)this.server.m_8243358();
        for (CommandMapping command : dispatcher.getCommands()) {
            CommandWrapper wrapper = new CommandWrapper(command);
            mcMan.m_2034289((C_8433864)wrapper);
        }
    }

    public void registerGameHooks() {
        this.hookingEvents = true;
    }

    public PropertiesConfiguration getConfiguration() {
        return this.mod.getConfig();
    }

    public String getVersion() {
        return this.mod.getInternalVersion();
    }

    public String getPlatformName() {
        return "CarpetMod";
    }

    public String getPlatformVersion() {
        return this.mod.getInternalVersion();
    }

    public Map<Capability, Preference> getCapabilities() {
        EnumMap<Capability, Preference> capabilities = new EnumMap<Capability, Preference>(Capability.class);
        capabilities.put(Capability.CONFIGURATION, Preference.PREFER_OTHERS);
        capabilities.put(Capability.WORLDEDIT_CUI, Preference.NORMAL);
        capabilities.put(Capability.GAME_HOOKS, Preference.NORMAL);
        capabilities.put(Capability.PERMISSIONS, Preference.NORMAL);
        capabilities.put(Capability.USER_COMMANDS, Preference.NORMAL);
        capabilities.put(Capability.WORLD_EDITING, Preference.PREFERRED);
        return capabilities;
    }

    public Collection<Actor> getConnectedUsers() {
        ArrayList<Actor> users = new ArrayList<Actor>();
        C_9992501 scm = this.server.m_8526012();
        for (C_3292284 entity : scm.m_8800532()) {
            if (entity == null) continue;
            users.add((Actor)new VanillaPlayer(entity));
        }
        return users;
    }
}

