/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.LocalWorldAdapter;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.unmapped.C_1008454;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_3755722;
import net.minecraft.unmapped.C_5385258;
import net.minecraft.unmapped.C_7240405;
import net.minecraft.unmapped.C_9550253;
import webridge.ThreadSafeCache;
import webridge.VanillaWorldEdit;
import webridge.WECUIPacketHandler;
import webridge.WorldEditBridge;

class VanillaPlayer
extends AbstractPlayerActor {
    private final C_3292284 player;

    protected VanillaPlayer(C_3292284 player) {
        this.player = player;
        ThreadSafeCache.getInstance().getOnlineIds().add(this.getUniqueId());
    }

    public UUID getUniqueId() {
        return this.player.m_2013188();
    }

    public int getItemInHand() {
        C_2454309 is = this.player.m_6358554();
        return is == null ? 0 : C_3755722.m_1350352((C_3755722)is.m_2410511());
    }

    public String getName() {
        return this.player.m_6689989();
    }

    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    public Location getLocation() {
        Vector position = new Vector(this.player.f_6638345, this.player.f_1187082, this.player.f_9103758);
        return new Location((Extent)VanillaWorldEdit.inst.getWorld(this.player.f_4703454), position, this.player.f_9290364, this.player.f_0565533);
    }

    public WorldVector getPosition() {
        return new WorldVector((LocalWorld)LocalWorldAdapter.adapt((World)VanillaWorldEdit.inst.getWorld(this.player.f_4703454)), this.player.f_6638345, this.player.f_1187082, this.player.f_9103758);
    }

    public World getWorld() {
        return VanillaWorldEdit.inst.getWorld(this.player.f_4703454);
    }

    public double getPitch() {
        return this.player.f_0243146;
    }

    public double getYaw() {
        return this.player.f_7165431;
    }

    public void giveItem(int type, int amt) {
        this.player.f_3923819.m_4381741(new C_2454309(C_3755722.m_8425513((int)type), amt, 0));
    }

    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString((String[])params, (String)"|");
        }
        C_7240405 pb = new C_7240405(Unpooled.wrappedBuffer((byte[])send.getBytes(WECUIPacketHandler.UTF_8_CHARSET)));
        C_1008454 packet = new C_1008454("WECUI", pb);
        this.player.f_2111610.m_3258329((C_5385258)packet);
    }

    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.m_3031403((C_9550253)new C_1716360(part));
        }
    }

    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.m_3031403((C_9550253)new C_1716360("\u00a77" + part));
        }
    }

    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.m_3031403((C_9550253)new C_1716360("\u00a7d" + part));
        }
    }

    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.m_3031403((C_9550253)new C_1716360("\u00a7c" + part));
        }
    }

    public void setPosition(Vector pos, float pitch, float yaw) {
        this.player.f_2111610.m_6001791(pos.getX(), pos.getY(), pos.getZ(), pitch, yaw);
    }

    public String[] getGroups() {
        return new String[0];
    }

    public BlockBag getInventoryBlockBag() {
        return null;
    }

    public boolean hasPermission(String perm) {
        int requiredOpLevel;
        if (WorldEditBridge.isIntegratedServer) {
            return true;
        }
        int opLevel = WorldEditBridge.minecraftServer.m_8526012().m_4611177().m_1998202(this.player.m_2101945());
        return opLevel >= (requiredOpLevel = VanillaWorldEdit.inst.getConfig().getPermissionLevel(perm));
    }

    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.m_2013188(), this.player.m_6689989());
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return ThreadSafeCache.getInstance().getOnlineIds().contains(this.uuid);
        }

        public boolean isPersistent() {
            return true;
        }
    }
}

