/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.LazyBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.registry.WorldData;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_1316134;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_2441996;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_2891045;
import net.minecraft.unmapped.C_3622326;
import net.minecraft.unmapped.C_3628668;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_5818647;
import net.minecraft.unmapped.C_6849228;
import net.minecraft.unmapped.C_6928498;
import net.minecraft.unmapped.C_7141926;
import net.minecraft.unmapped.C_8252988;
import net.minecraft.unmapped.C_8300121;
import net.minecraft.unmapped.C_9848147;
import webridge.NBTConverter;
import webridge.TileEntityBaseBlock;
import webridge.TileEntityUtils;
import webridge.VanillaEntity;
import webridge.VanillaWorldData;
import webridge.VanillaWorldEdit;
import webridge.mixins.accessors.ChunkProviderServerAccessor;

class VanillaWorld
extends AbstractWorld {
    private static final Logger logger = Logger.getLogger(VanillaWorld.class.getCanonicalName());
    private final WeakReference<C_5553933> worldRef;

    VanillaWorld(C_5553933 world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<C_5553933>(world);
    }

    public C_5553933 getWorldChecked() throws WorldEditException {
        C_5553933 world = (C_5553933)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new WorldReferenceLostException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public C_5553933 getWorld() {
        C_5553933 world = (C_5553933)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public String getName() {
        return this.getWorld().m_6536808().m_3688463();
    }

    public boolean setBlock(Vector position, BaseBlock block, boolean notifyAndLight) throws WorldEditException {
        CompoundTag tag;
        C_2441996 newState;
        boolean successful;
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)block);
        C_5553933 world = this.getWorldChecked();
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        C_6849228 chunk = world.m_0750002(x >> 4, z >> 4);
        C_2441996 oldState = C_3628668.f_3097723.m_9077732();
        if (notifyAndLight) {
            oldState = chunk.m_9971171(x & 0xF, y, z & 0xF);
        }
        boolean bl = successful = chunk.m_0222822(new C_3674802(x, y, z), newState = C_1241852.m_7535518((int)block.getId()).m_7685061(block.getData())) != null;
        if (successful && (tag = block.getNbtData()) != null) {
            C_2018497 nativeTag = NBTConverter.toNative(tag);
            nativeTag.m_1991972("id", block.getNbtId());
            TileEntityUtils.setTileEntity(this.getWorld(), position, nativeTag);
        }
        C_3674802 pos = new C_3674802(x, y, z);
        if (notifyAndLight && (newState.m_2425426() != oldState.m_2425426() || newState.m_8514269() != oldState.m_8514269())) {
            world.m_6191491(pos);
        }
        world.m_0384893(pos, oldState, newState, 3);
        if (notifyAndLight) {
            world.m_5170064(pos, oldState.m_0999604(), true);
            if (newState.m_8470618()) {
                world.m_9724606(pos, newState.m_0999604());
            }
        }
        return successful;
    }

    public int getBlockLightLevel(Vector position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().m_8566267(C_2891045.f_5218837, new C_3674802(position.getBlockX(), position.getBlockY(), position.getBlockZ()));
    }

    public boolean clearContainerBlockContents(Vector position) {
        Preconditions.checkNotNull((Object)position);
        C_3622326 tile = this.getWorld().m_8048103(new C_3674802(position.getBlockX(), position.getBlockY(), position.getBlockZ()));
        if (tile instanceof C_5818647) {
            C_5818647 inv = (C_5818647)tile;
            int size = inv.m_2930514();
            for (int i = 0; i < size; ++i) {
                inv.m_1063275(i, C_2454309.f_8575853);
            }
            return true;
        }
        return false;
    }

    public BaseBiome getBiome(Vector2D position) {
        Preconditions.checkNotNull((Object)position);
        return new BaseBiome(C_6928498.m_7889664((C_6928498)this.getWorld().m_4932347(new C_3674802(position.getBlockX(), 0, position.getBlockZ()))));
    }

    public boolean setBiome(Vector2D position, BaseBiome biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        C_3674802 pos = new C_3674802(position.getBlockX(), 0, position.getBlockZ());
        if (this.getWorld().m_2479214(pos)) {
            C_6849228 chunk = this.getWorld().m_4745553(pos);
            chunk.m_6712303()[(position.getBlockZ() & 0xF) << 4 | position.getBlockX() & 0xF] = (byte)biome.getId();
            return true;
        }
        return false;
    }

    public void dropItem(Vector position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == 0) {
            return;
        }
        C_8300121 entity = new C_8300121(this.getWorld(), position.getX(), position.getY(), position.getZ(), VanillaWorldEdit.toCarpetItemStack(item));
        entity.m_4901560();
        this.getWorld().m_1727586((C_0539808)entity);
    }

    public boolean regenerate(Region region, EditSession editSession) {
        BaseBlock[] history = new BaseBlock[256 * (this.getMaxY() + 1)];
        for (Vector2D chunk : region.getChunks()) {
            Vector pt;
            int x;
            Vector min = new Vector(chunk.getBlockX() * 16, 0, chunk.getBlockZ() * 16);
            for (x = 0; x < 16; ++x) {
                for (int y = 0; y < this.getMaxY() + 1; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        pt = min.add(x, y, z);
                        int index = y * 16 * 16 + z * 16 + x;
                        history[index] = editSession.getBlock(pt);
                    }
                }
            }
            try {
                Set chunks = region.getChunks();
                C_9848147 provider = this.getWorld().m_6488616();
                if (!(provider instanceof C_1316134)) {
                    return false;
                }
                C_1316134 chunkServer = (C_1316134)provider;
                Set<Long> unloadQueue = ((ChunkProviderServerAccessor)chunkServer).getDroppedChunks();
                Long2ObjectMap<C_6849228> loadedMap = ((ChunkProviderServerAccessor)chunkServer).getLoadedChunks();
                for (Vector2D coord : chunks) {
                    C_6849228 mcChunk;
                    long pos = C_7141926.m_1427709((int)coord.getBlockX(), (int)coord.getBlockZ());
                    if (chunkServer.m_7591747(coord.getBlockX(), coord.getBlockZ())) {
                        mcChunk = chunkServer.m_4129669(coord.getBlockX(), coord.getBlockZ());
                        mcChunk.m_4066043();
                    }
                    unloadQueue.remove(pos);
                    loadedMap.remove(pos);
                    mcChunk = chunkServer.m_8714752(coord.getBlockX(), coord.getBlockZ());
                    loadedMap.put(pos, (Object)mcChunk);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Failed to generate chunk", t);
                return false;
            }
            for (x = 0; x < 16; ++x) {
                for (int y = 0; y < this.getMaxY() + 1; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        pt = min.add(x, y, z);
                        int index = y * 16 * 16 + z * 16 + x;
                        if (!region.contains(pt)) {
                            editSession.smartSetBlock(pt, history[index]);
                            continue;
                        }
                        editSession.rememberChange(pt, history[index], editSession.rawGetBlock(pt));
                    }
                }
            }
        }
        return false;
    }

    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector position) throws MaxChangedBlocksException {
        return false;
    }

    public WorldData getWorldData() {
        return VanillaWorldData.getInstance();
    }

    public boolean isValidBlockType(int id) {
        return id == 0 || C_1241852.m_7535518((int)id) != null;
    }

    public BaseBlock getBlock(Vector position) {
        C_5553933 world = this.getWorld();
        C_3674802 pos = new C_3674802((double)position.getBlockX(), (double)position.getBlockY(), position.getZ());
        C_2441996 state = world.m_4919395(pos);
        int id = C_1241852.m_8163480((C_1241852)state.m_0999604());
        int data = state.m_0999604().m_5249160(state);
        C_3622326 tile = this.getWorld().m_8048103(pos);
        if (tile != null) {
            return new TileEntityBaseBlock(id, data, tile);
        }
        return new BaseBlock(id, data);
    }

    public BaseBlock getLazyBlock(Vector position) {
        C_5553933 world = this.getWorld();
        C_2441996 state = world.m_4919395(new C_3674802(position.getBlockX(), position.getBlockY(), position.getBlockZ()));
        int id = C_1241852.m_8163480((C_1241852)state.m_0999604());
        int data = state.m_0999604().m_5249160(state);
        return new LazyBlock(id, data, (Extent)this, position);
    }

    public int hashCode() {
        return this.getWorld().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof VanillaWorld) {
            VanillaWorld other = (VanillaWorld)((Object)o);
            C_5553933 otherWorld = (C_5553933)other.worldRef.get();
            C_5553933 thisWorld = (C_5553933)this.worldRef.get();
            return otherWorld != null && thisWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof World) {
            return ((World)o).getName().equals(this.getName());
        }
        return false;
    }

    public List<? extends Entity> getEntities(Region region) {
        ArrayList<VanillaEntity> entities = new ArrayList<VanillaEntity>();
        C_5553933 world = this.getWorld();
        List ents = world.f_5094163;
        for (C_0539808 entity : ents) {
            if (!region.contains(new Vector(entity.f_6638345, entity.f_1187082, entity.f_9103758))) continue;
            entities.add(new VanillaEntity(entity));
        }
        return entities;
    }

    public List<? extends Entity> getEntities() {
        ArrayList<VanillaEntity> entities = new ArrayList<VanillaEntity>();
        for (Object entity : this.getWorld().f_5094163) {
            entities.add(new VanillaEntity((C_0539808)entity));
        }
        return entities;
    }

    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        C_5553933 world = this.getWorld();
        C_0539808 createdEntity = C_8252988.m_3998715((C_0561170)new C_0561170(entity.getTypeId()), (C_5553933)world);
        if (createdEntity != null) {
            CompoundTag nativeTag = entity.getNbtData();
            if (nativeTag != null) {
                C_2018497 tag = NBTConverter.toNative(entity.getNbtData());
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.m_6588629(name);
                }
                createdEntity.m_3608898(tag);
            }
            createdEntity.m_0375747(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            world.m_1727586(createdEntity);
            return new VanillaEntity(createdEntity);
        }
        return null;
    }

    private static class WorldReferenceLostException
    extends WorldEditException {
        private WorldReferenceLostException(String message) {
            super(message);
        }
    }
}

