/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.history.change.BlockChange;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.history.change.EntityCreate;
import com.sk89q.worldedit.history.change.EntityRemove;
import com.sk89q.worldedit.internal.LocalWorldAdapter;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_0230498;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_1730529;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_2441996;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_3622326;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_3755722;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_8252988;
import net.minecraft.unmapped.C_8433864;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import webridge.NBTConverter;
import webridge.ThreadSafeCache;
import webridge.VanillaBiomeRegistry;
import webridge.VanillaConfiguration;
import webridge.VanillaEntity;
import webridge.VanillaPlatform;
import webridge.VanillaPlayer;
import webridge.VanillaWorld;

public class VanillaWorldEdit {
    public static Logger logger;
    public static final String MOD_ID = "worldedit";
    public static final String CUI_PLUGIN_CHANNEL = "WECUI";
    public static VanillaWorldEdit inst;
    private VanillaPlatform platform;
    private VanillaConfiguration config;
    private boolean firstTick = true;
    private EditSession editSession = null;
    private int sessionNestedDepth = 0;

    public void onServerLoaded(MinecraftServer server) {
        logger = LogManager.getLogger((String)"WorldEdit");
        this.config = new VanillaConfiguration(new File("worldedit.properties").getAbsoluteFile());
        this.config.load();
        VanillaBiomeRegistry.populate();
        this.platform = new VanillaPlatform(this);
        WorldEdit.getInstance().getPlatformManager().register((Platform)this.platform);
    }

    public void onServerStopped(MinecraftServer server) {
        this.firstTick = true;
        WorldEdit.getInstance().getPlatformManager().unregister((Platform)this.platform);
    }

    public void onStartTick() {
        ThreadSafeCache.getInstance().tickStart();
        if (this.firstTick) {
            this.firstTick = false;
            WorldEdit.getInstance().getEventBus().post((Object)new PlatformReadyEvent());
        }
    }

    public void onCommand(C_8433864 command, C_1730529 sender, String[] args) {
        if (sender instanceof C_3292284) {
            if (((C_3292284)sender).f_4703454.f_0122188) {
                return;
            }
            Object[] split = new String[args.length + 1];
            System.arraycopy(args, 0, split, 1, args.length);
            split[0] = command.m_2274818();
            CommandEvent weEvent = new CommandEvent((Actor)this.wrap((C_3292284)sender), Joiner.on((String)" ").join(split));
            WorldEdit.getInstance().getEventBus().post((Object)weEvent);
        }
    }

    public boolean onLeftClickBlock(C_5553933 world, C_3674802 pos, C_3292284 player) {
        if (!this.platform.isHookingEvents()) {
            return true;
        }
        WorldEdit we = WorldEdit.getInstance();
        VanillaPlayer vanillaPlayer = this.wrap(player);
        VanillaWorld vanillaWorld = this.getWorld(world);
        WorldVector vector = new WorldVector((LocalWorld)LocalWorldAdapter.adapt((World)vanillaWorld), pos.m_9150363(), pos.m_4798774(), pos.m_3900258());
        boolean result = true;
        if (we.handleBlockLeftClick((Player)vanillaPlayer, vector)) {
            result = false;
        }
        if (we.handleArmSwing((Player)vanillaPlayer)) {
            result = false;
        }
        return result;
    }

    public boolean onRightClickBlock(C_5553933 world, C_3674802 pos, C_3292284 player) {
        if (!this.platform.isHookingEvents()) {
            return true;
        }
        WorldEdit we = WorldEdit.getInstance();
        VanillaPlayer vanillaPlayer = this.wrap(player);
        VanillaWorld vanillaWorld = this.getWorld(world);
        WorldVector vector = new WorldVector((LocalWorld)LocalWorldAdapter.adapt((World)vanillaWorld), pos.m_9150363(), pos.m_4798774(), pos.m_3900258());
        boolean result = true;
        if (we.handleBlockRightClick((Player)vanillaPlayer, vector)) {
            result = false;
        }
        if (we.handleRightClick((Player)vanillaPlayer)) {
            result = false;
        }
        return result;
    }

    public boolean onRightClickAir(C_5553933 world, C_3292284 player) {
        VanillaPlayer vanillaPlayer;
        if (!this.platform.isHookingEvents()) {
            return true;
        }
        WorldEdit we = WorldEdit.getInstance();
        return !we.handleRightClick((Player)(vanillaPlayer = this.wrap(player)));
    }

    public void startEditSession(C_3292284 player) {
        if (player == null) {
            return;
        }
        ++this.sessionNestedDepth;
        if (this.editSession == null) {
            VanillaPlayer vanillaPlayer = this.wrap(player);
            this.editSession = WorldEdit.getInstance().getSessionManager().get((SessionOwner)vanillaPlayer).createEditSession((Player)vanillaPlayer);
        }
    }

    public void finishEditSession(C_3292284 player) {
        if (player == null) {
            return;
        }
        if (this.editSession == null) {
            throw new IllegalStateException("Not started!");
        }
        --this.sessionNestedDepth;
        if (this.sessionNestedDepth == 0) {
            VanillaPlayer vanillaPlayer = this.wrap(player);
            if (this.editSession.getChangeSet().size() > 0) {
                WorldEdit.getInstance().getSessionManager().get((SessionOwner)vanillaPlayer).remember(this.editSession);
            }
            this.editSession = null;
        }
    }

    public void recordBlockEdit(C_3292284 player, C_5553933 world, C_3674802 pos, C_2441996 newBlock, C_2018497 newTileEntity) {
        if (player == null) {
            return;
        }
        if (this.editSession == null) {
            throw new IllegalStateException("Not started!");
        }
        BlockVector position = new BlockVector(pos.m_9150363(), pos.m_4798774(), pos.m_3900258());
        C_2441996 oldBlock = world.m_4919395(pos);
        int oldBlockId = C_1241852.m_8163480((C_1241852)oldBlock.m_0999604());
        int oldMeta = oldBlock.m_0999604().m_5249160(oldBlock);
        C_3622326 oldTileEntity = world.m_8048103(pos);
        BaseBlock previous = oldTileEntity == null ? new BaseBlock(oldBlockId, oldMeta) : new BaseBlock(oldBlockId, oldMeta, NBTConverter.fromNative(oldTileEntity.m_7291294(new C_2018497())));
        int newBlockId = C_1241852.m_8163480((C_1241852)newBlock.m_0999604());
        int newMeta = newBlock.m_0999604().m_5249160(newBlock);
        BaseBlock current = newTileEntity == null ? new BaseBlock(newBlockId, newMeta) : new BaseBlock(newBlockId, newMeta, NBTConverter.fromNative(newTileEntity));
        this.editSession.getChangeSet().add((Change)new BlockChange(position, previous, current));
    }

    public void recordEntityCreation(C_3292284 player, C_5553933 world, C_0539808 created) {
        if (player == null) {
            return;
        }
        if (this.editSession == null) {
            throw new IllegalStateException("Not started!");
        }
        VanillaEntity vanillaEntity = new VanillaEntity(created);
        String entityId = C_8252988.m_5554506((C_0539808)created).toString();
        CompoundTag tag = NBTConverter.fromNative(created.m_7690388(new C_2018497()));
        BaseEntity baseEntity = new BaseEntity(entityId, tag);
        this.editSession.getChangeSet().add((Change)new EntityCreate(vanillaEntity.getLocation(), baseEntity, (Entity)vanillaEntity));
    }

    public void recordEntityRemoval(C_3292284 player, C_5553933 world, C_0539808 removed) {
        if (player == null) {
            return;
        }
        if (this.editSession == null) {
            throw new IllegalStateException("Not started!");
        }
        VanillaEntity vanillaEntity = new VanillaEntity(removed);
        String entityId = C_8252988.m_5554506((C_0539808)removed).toString();
        CompoundTag tag = NBTConverter.fromNative(removed.m_7690388(new C_2018497()));
        BaseEntity baseEntity = new BaseEntity(entityId, tag);
        this.editSession.getChangeSet().add((Change)new EntityRemove(vanillaEntity.getLocation(), baseEntity));
    }

    public static C_2454309 toCarpetItemStack(BaseItemStack item) {
        C_2454309 ret = new C_2454309(C_3755722.m_8425513((int)item.getType()), item.getAmount(), (int)item.getData());
        for (Map.Entry entry : item.getEnchantments().entrySet()) {
            ret.m_2528595(C_0230498.m_1591793((int)((Integer)entry.getKey())), ((Integer)entry.getValue()).intValue());
        }
        return ret;
    }

    VanillaConfiguration getConfig() {
        return this.config;
    }

    public VanillaPlayer wrap(C_3292284 player) {
        Preconditions.checkNotNull((Object)player);
        return new VanillaPlayer(player);
    }

    public LocalSession getSession(C_3292284 player) {
        Preconditions.checkNotNull((Object)player);
        return WorldEdit.getInstance().getSessionManager().get((SessionOwner)this.wrap(player));
    }

    public VanillaWorld getWorld(C_5553933 world) {
        Preconditions.checkNotNull((Object)world);
        return new VanillaWorld(world);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    String getInternalVersion() {
        return "1.0.0";
    }

    static {
        inst = new VanillaWorldEdit();
    }
}

