/*
 * Decompiled with CFR 0.152.
 */
package webridge;

import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_1730529;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_2441996;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_8433864;
import net.minecraft.unmapped.C_9540883;
import webridge.VanillaWorldEdit;
import webridge.WECUIPacketHandler;

public class WorldEditBridge {
    public static final String VERSION = "1.0.0";
    public static MinecraftServer minecraftServer;
    public static boolean worldEditPresent;
    public static boolean isIntegratedServer;

    public static void init() {
        try {
            Class.forName("com.sk89q.worldedit.WorldEdit");
            worldEditPresent = true;
        }
        catch (ClassNotFoundException e) {
            worldEditPresent = false;
        }
    }

    public static void loadMinecraftServer(MinecraftServer server) {
        minecraftServer = server;
    }

    public static void onServerLoaded(MinecraftServer server) {
        if (worldEditPresent) {
            VanillaWorldEdit.inst.onServerLoaded(server);
        }
    }

    public static void onServerStopped(MinecraftServer server) {
        if (minecraftServer != null) {
            VanillaWorldEdit.inst.onServerStopped(server);
            minecraftServer = null;
        }
    }

    public static boolean worldEditEnabled() {
        return worldEditPresent;
    }

    public static void onStartTick() {
        if (worldEditPresent) {
            VanillaWorldEdit.inst.onStartTick();
        }
    }

    public static void onCommand(C_8433864 command, C_1730529 sender, String[] args) {
        if (WorldEditBridge.worldEditEnabled()) {
            VanillaWorldEdit.inst.onCommand(command, sender, args);
        }
    }

    public static boolean onLeftClickBlock(C_5553933 world, C_3674802 pos, C_3292284 player) {
        if (WorldEditBridge.worldEditEnabled()) {
            return VanillaWorldEdit.inst.onLeftClickBlock(world, pos, player);
        }
        return true;
    }

    public static boolean onRightClickBlock(C_5553933 world, C_3674802 pos, C_3292284 player) {
        if (WorldEditBridge.worldEditEnabled()) {
            return VanillaWorldEdit.inst.onRightClickBlock(world, pos, player);
        }
        return true;
    }

    public static boolean onRightClickAir(C_5553933 world, C_3292284 player) {
        if (WorldEditBridge.worldEditEnabled()) {
            return VanillaWorldEdit.inst.onRightClickAir(world, player);
        }
        return true;
    }

    public static void onCustomPayload(C_9540883 packet, C_3292284 player) {
        if (WorldEditBridge.worldEditEnabled()) {
            WECUIPacketHandler.onCustomPayload(packet, player);
        }
    }

    public static void startEditSession(C_3292284 player) {
        if (WorldEditBridge.worldEditEnabled()) {
            VanillaWorldEdit.inst.startEditSession(player);
        }
    }

    public static void finishEditSession(C_3292284 player) {
        if (WorldEditBridge.worldEditEnabled()) {
            VanillaWorldEdit.inst.finishEditSession(player);
        }
    }

    public static void recordBlockEdit(C_3292284 player, C_5553933 world, C_3674802 pos, C_2441996 newBlock, C_2018497 newTileEntity) {
        if (WorldEditBridge.worldEditEnabled()) {
            VanillaWorldEdit.inst.recordBlockEdit(player, world, pos, newBlock, newTileEntity);
        }
    }

    public static void recordEntityCreation(C_3292284 player, C_5553933 world, C_0539808 created) {
        if (WorldEditBridge.worldEditEnabled()) {
            VanillaWorldEdit.inst.recordEntityCreation(player, world, created);
        }
    }

    public static void recordEntityRemoval(C_3292284 player, C_5553933 world, C_0539808 removed) {
        if (WorldEditBridge.worldEditEnabled()) {
            VanillaWorldEdit.inst.recordEntityRemoval(player, world, removed);
        }
    }
}

