/*
 * Decompiled with CFR 0.152.
 */
package webridge.mixins.events.record;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_0560185;
import net.minecraft.unmapped.C_1730529;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_2441996;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_3628668;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_8300121;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import webridge.WorldEditBridge;
import webridge.helpers.CapturedDrops;

@Mixin(value={C_0560185.class})
public abstract class CommandSetBlockMixin {
    C_2018497 worldEditTag;
    C_3292284 worldEditPlayer;

    @Inject(method={"execute"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="args", local={@Local(type=String[].class, argsOnly=true)})
    @Expression(value={"args.length >= 6"})
    private void setup(MinecraftServer server, C_1730529 sender, String[] args, CallbackInfo ci, @Local boolean flag, @Local C_2018497 nbttagcompound) {
        this.worldEditPlayer = sender instanceof C_3292284 ? (C_3292284)sender : null;
        this.worldEditTag = flag ? nbttagcompound : null;
    }

    @Inject(method={"execute"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;destroyBlock(Lnet/minecraft/util/math/BlockPos;Z)Z")})
    private void preDestroy(MinecraftServer server, C_1730529 sender, String[] args, CallbackInfo ci, @Local C_5553933 world, @Local C_3674802 blockPos) {
        WorldEditBridge.recordBlockEdit(this.worldEditPlayer, world, blockPos, C_3628668.f_3097723.m_9077732(), this.worldEditTag);
        CapturedDrops.setCapturingDrops(true);
    }

    @Inject(method={"execute"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;destroyBlock(Lnet/minecraft/util/math/BlockPos;Z)Z", shift=At.Shift.AFTER)})
    private void postDestroy(MinecraftServer server, C_1730529 sender, String[] args, CallbackInfo ci, @Local C_5553933 world) {
        CapturedDrops.setCapturingDrops(false);
        for (C_8300121 drop : CapturedDrops.getCapturedDrops()) {
            WorldEditBridge.recordEntityCreation(this.worldEditPlayer, world, (C_0539808)drop);
        }
        CapturedDrops.clearCapturedDrops();
    }

    @Inject(method={"execute"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getTileEntity(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/tileentity/TileEntity;", ordinal=0)})
    private void recordBlockEdit(MinecraftServer server, C_1730529 sender, String[] args, CallbackInfo ci, @Local C_5553933 world, @Local C_3674802 blockPos, @Local C_2441996 iBlockState) {
        WorldEditBridge.recordBlockEdit(this.worldEditPlayer, world, blockPos, iBlockState, this.worldEditTag);
    }
}

