/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.common.entity.animal.koi.Koi;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KoiModel<T extends Koi>
extends EntityModel<T> {
    private final ModelPart front;
    private final ModelPart back;
    private final ModelPart tail;

    public KoiModel(ModelPart root) {
        this.front = root.getChild("front");
        this.back = root.getChild("back");
        this.tail = root.getChild("back").getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition front = root.addOrReplaceChild("front", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)1.0f));
        PartDefinition head = front.addOrReplaceChild("head", CubeListBuilder.create().texOffs(20, 3).addBox(-1.5f, -4.0f, -4.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-5.0f));
        PartDefinition leftWhisker = head.addOrReplaceChild("leftWhisker", CubeListBuilder.create().texOffs(20, 9).addBox(1.5f, -3.0f, -8.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)4.0f));
        PartDefinition rightWhisker = head.addOrReplaceChild("rightWhisker", CubeListBuilder.create().texOffs(20, 9).addBox(-1.5f, -3.0f, -8.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)4.0f));
        PartDefinition bodyFront = front.addOrReplaceChild("bodyFront", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -6.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition frontFin = bodyFront.addOrReplaceChild("frontFin", CubeListBuilder.create().texOffs(14, -1).addBox(0.0f, -10.0f, -3.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition frontLeftFin = bodyFront.addOrReplaceChild("frontLeftFin", CubeListBuilder.create().texOffs(6, 14).addBox(2.0f, -3.0f, -5.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition frontRightFin = bodyFront.addOrReplaceChild("frontRightFin", CubeListBuilder.create().texOffs(6, 14).addBox(-2.0f, -3.0f, -5.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition back = root.addOrReplaceChild("back", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)1.0f));
        PartDefinition bodyBack = back.addOrReplaceChild("bodyBack", CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition backFin = bodyBack.addOrReplaceChild("backFin", CubeListBuilder.create().texOffs(15, 9).addBox(0.0f, -10.0f, 1.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition backRightFin = bodyBack.addOrReplaceChild("backRightFin", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, -3.0f, 3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition backLeftFin = bodyBack.addOrReplaceChild("backLeftFin", CubeListBuilder.create().texOffs(0, 18).addBox(2.0f, -3.0f, 3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition tail = back.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, 12).addBox(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        ImmutableList.of((Object)this.front, (Object)this.back).forEach(modelRenderer -> modelRenderer.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isInWater()) {
            this.front.yRot = Mth.sin((float)(0.6f * ageInTicks)) * 0.3f * limbSwingAmount;
            this.back.yRot = Mth.cos((float)(0.6f * ageInTicks)) * 0.7f * limbSwingAmount;
            this.tail.yRot = Mth.sin((float)(0.6f * ageInTicks)) * 0.75f * limbSwingAmount;
        } else {
            this.back.yRot = Mth.cos((float)(1.0200001f * ageInTicks)) * 0.325f;
        }
    }
}

