/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlabfishModel<E extends Slabfish>
extends AgeableListModel<E> {
    public ModelPart body;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart rightArm;
    public ModelPart leftArm;
    public ModelPart fin;
    public ModelPart backpack;
    public TextureAtlasSprite sprite;
    private float partialTicks;

    public SlabfishModel(ModelPart root) {
        this.body = root.getChild("body");
        this.leftArm = this.body.getChild("left_arm");
        this.rightArm = this.body.getChild("right_arm");
        this.fin = this.body.getChild("fin");
        this.backpack = this.body.getChild("backpack");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -2.0f, 10.0f, 10.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f, true), PartPose.offsetAndRotation((float)5.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.43633232f));
        PartDefinition rightArm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)-5.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.43633232f));
        PartDefinition fin = body.addOrReplaceChild("fin", CubeListBuilder.create().texOffs(24, 12).addBox(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)2.0f, (float)-0.21816616f, (float)0.0f, (float)0.0f));
        PartDefinition backpack = body.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(8, 20).addBox(-4.0f, -8.0f, 2.0f, 8.0f, 8.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, false), PartPose.offsetAndRotation((float)-2.5f, (float)19.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, true), PartPose.offsetAndRotation((float)2.5f, (float)19.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void prepareMobModel(E entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        this.partialTicks = partialTicks;
    }

    public void setupAnim(E slabfish, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.fin.visible = !((Slabfish)((Object)slabfish)).hasBackpack();
        this.body.zRot = 0.1f * Mth.sin((float)(limbSwing * 0.5f)) * 1.25f * limbSwingAmount;
        if (((Slabfish)((Object)slabfish)).isPartying() && !slabfish.isInWater()) {
            this.body.z = Mth.cos((float)((float)((Slabfish)((Object)slabfish)).tickCount + this.partialTicks));
            this.body.y = 19.75f - Mth.sin((float)((float)((Slabfish)((Object)slabfish)).tickCount + this.partialTicks));
        } else {
            this.body.z = 0.0f;
            this.body.y = 19.0f;
        }
        if (!slabfish.isInWater()) {
            this.rightArm.zRot = ageInTicks;
            this.leftArm.zRot = -ageInTicks;
            this.rightLeg.xRot = slabfish.isInSittingPose() || slabfish.getVehicle() != null ? -1.57f : Mth.cos((float)(limbSwing * 0.6662f)) * 1.5f * limbSwingAmount;
            this.leftLeg.xRot = slabfish.isInSittingPose() || slabfish.getVehicle() != null ? -1.57f : Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.5f * limbSwingAmount;
        } else {
            this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.7f * limbSwingAmount;
            this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.7f * limbSwingAmount;
            this.rightArm.zRot = ageInTicks;
            this.leftArm.zRot = -ageInTicks;
        }
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(matrixStack, this.sprite.wrap(buffer), packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg);
    }
}

