/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class YakModel<E extends Yak>
extends QuadrupedModel<E> {
    private static final float RELATIVE_HEAD_Y = 8.0f;
    private static final float ADULT_EAT_OFFSET_MULTIPLIER = 9.0f;
    private static final float CHILD_EAT_OFFSET_MULTIPLIER = 3.0f;
    public ModelPart coat;

    public YakModel(ModelPart root) {
        super(root, false, 8.0f, 5.0f, 2.0f, 2.0f, 24);
        this.coat = root.getChild("body").getChild("coat");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -6.0f, 8.0f, 10.0f, 8.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)-12.0f));
        head.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(0, 18).addBox(4.0f, -15.0f, -13.0f, 6.0f, 3.0f, 3.0f).texOffs(0, 24).addBox(8.0f, -19.0f, -12.0f, 2.0f, 4.0f, 2.0f).texOffs(0, 32).addBox(6.0f, -19.0f, -12.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)8.0f));
        head.addOrReplaceChild("right_horn", CubeListBuilder.create().mirror().texOffs(0, 18).addBox(-10.0f, -15.0f, -13.0f, 6.0f, 3.0f, 3.0f).texOffs(0, 24).addBox(-10.0f, -19.0f, -12.0f, 2.0f, 4.0f, 2.0f).texOffs(0, 32).addBox(-8.0f, -19.0f, -12.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)8.0f));
        head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(32, 12).addBox(-5.0f, -4.0f, -1.0f, 6.0f, 4.0f, 2.0f), PartPose.offset((float)2.0f, (float)5.0f, (float)-7.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(60, 0).addBox(-7.0f, -16.0f, -6.0f, 14.0f, 19.0f, 20.0f).texOffs(80, 44).addBox(-7.0f, -2.0f, -6.0f, 14.0f, 0.0f, 20.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-4.0f));
        body.addOrReplaceChild("coat", CubeListBuilder.create().texOffs(0, 18).addBox(-9.0f, -17.0f, -8.0f, 18.0f, 17.0f, 24.0f), PartPose.ZERO);
        root.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().mirror().texOffs(48, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f), PartPose.offset((float)-4.0f, (float)17.0f, (float)7.0f));
        root.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f), PartPose.offset((float)4.0f, (float)17.0f, (float)7.0f));
        root.addOrReplaceChild("right_front_leg", CubeListBuilder.create().mirror().texOffs(48, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f), PartPose.offset((float)-4.0f, (float)17.0f, (float)-7.0f));
        root.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f), PartPose.offset((float)4.0f, (float)17.0f, (float)-7.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void prepareMobModel(E yak, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.prepareMobModel(yak, limbSwing, limbSwingAmount, partialTicks);
        this.coat.visible = !((Yak)((Object)yak)).isSheared();
    }

    public void setupAnim(E yak, float limbSwing, float limbSwingAmount, float ageInTicks, float yaw, float pitch) {
        super.setupAnim(yak, limbSwing, limbSwingAmount, ageInTicks, yaw, pitch);
        float partialTicks = ageInTicks - (float)((Yak)((Object)yak)).tickCount;
        this.head.y = 8.0f + ((Yak)((Object)yak)).getHeadEatingOffset(partialTicks) * (yak.isBaby() ? 3.0f : 9.0f);
        this.head.xRot = ((Yak)((Object)yak)).getHeadPitch(partialTicks);
    }
}

