/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CattailFluffParticle
extends TextureSheetParticle {
    private float angle;

    public CattailFluffParticle(ClientLevel world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.xd = motionX;
        this.yd = motionY + this.random.nextDouble() * 0.01;
        this.zd = motionZ;
        this.angle = (float)Math.random() * ((float)Math.PI * 2);
        this.lifetime = this.random.nextInt(50) + 50;
        this.quadSize = 0.2f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    public void tick() {
        if (this.age % 5 == 0) {
            this.angle = (float)Math.random() * ((float)Math.PI * 2);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            this.xd += Math.cos(this.angle) * 1.0E-4;
            this.zd += Math.sin(this.angle) * 1.0E-4;
        }
        this.alpha -= (float)this.lifetime / 10000.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet animatedSprite;

        public Factory(SpriteSet animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CattailFluffParticle particle = new CattailFluffParticle(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.animatedSprite);
            return particle;
        }
    }
}

