/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.environmental.client.model.KoiModel;
import com.teamabnormals.environmental.common.entity.animal.koi.Koi;
import com.teamabnormals.environmental.common.entity.animal.koi.KoiVariant;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KoiRenderer
extends MobRenderer<Koi, KoiModel<Koi>> {
    public KoiRenderer(EntityRendererProvider.Context context) {
        super(context, new KoiModel(context.bakeLayer(EnvironmentalModelLayers.KOI)), 0.3f);
    }

    public ResourceLocation getTextureLocation(Koi koi) {
        return ((KoiVariant)koi.getVariant().value()).texture().withPrefix("textures/").withSuffix(".png");
    }

    public void setupRotations(Koi koi, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)koi, poseStack, ageInTicks, rotationYaw, partialTicks, scale);
        if (koi.isInWater()) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)koi.xRotO, (float)koi.getXRot())));
        } else {
            poseStack.translate((double)0.2f, (double)0.1f, 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

