/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.environmental.client.model.SlabfishModel;
import com.teamabnormals.environmental.client.renderer.entity.layers.BackpackOverlayRenderLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.BackpackRenderLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.OverlayRenderLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.SweaterRenderLayer;
import com.teamabnormals.environmental.client.resources.SlabfishSpriteUploader;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.slabfish.SlabfishVariant;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlabfishRenderer
extends MobRenderer<Slabfish, SlabfishModel<Slabfish>> {
    public SlabfishRenderer(EntityRendererProvider.Context context) {
        super(context, new SlabfishModel(context.bakeLayer(EnvironmentalModelLayers.SLABFISH)), 0.3f);
        this.addLayer(new SweaterRenderLayer(this));
        this.addLayer(new BackpackRenderLayer(this));
        this.addLayer(new OverlayRenderLayer(this));
        this.addLayer(new BackpackOverlayRenderLayer(this));
    }

    public ResourceLocation getTextureLocation(Slabfish slabby) {
        return SlabfishSpriteUploader.ATLAS_LOCATION;
    }

    protected RenderType getRenderType(Slabfish slabby, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation texture = this.getTextureLocation(slabby);
        if (p_230496_3_) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
        }
        if (p_230496_2_) {
            return SlabfishVariant.isTranslucent(slabby.getVariant()) ? RenderType.entityTranslucent((ResourceLocation)texture) : ((SlabfishModel)this.model).renderType(texture);
        }
        return p_230496_4_ ? RenderType.outline((ResourceLocation)texture) : null;
    }

    protected float getBob(Slabfish livingBase, float partialTicks) {
        float f = Mth.lerp((float)partialTicks, (float)livingBase.oFlap, (float)livingBase.wingRotation);
        float f1 = Mth.lerp((float)partialTicks, (float)livingBase.oFlapSpeed, (float)livingBase.destPos);
        return (Mth.sin((float)f) + 1.0f) * f1;
    }

    protected void scale(Slabfish slabfish, PoseStack matrixStack, float partialTickTime) {
        ((SlabfishModel)this.model).sprite = SlabfishSpriteUploader.instance().getSprite(((SlabfishVariant)slabfish.getVariant().value()).texture());
        if (slabfish.isInSittingPose() || slabfish.getVehicle() != null) {
            matrixStack.translate(0.0f, slabfish.isBaby() ? 0.15625f : 0.3125f, 0.0f);
        }
        if (slabfish.isInWater()) {
            matrixStack.translate(0.0, -0.35, slabfish.isBaby() ? 0.25 : 0.5);
            matrixStack.mulPose(Axis.XP.rotation(1.5707964f));
        }
    }
}

