/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity;

import com.teamabnormals.environmental.client.model.ZorseModel;
import com.teamabnormals.environmental.client.renderer.entity.layers.ZorseArmorLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.ZorseMarkingsLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.ZorseStripesRenderLayer;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zorse;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ZorseRenderer
extends MobRenderer<Zorse, ZorseModel<Zorse>> {
    public ZorseRenderer(EntityRendererProvider.Context context) {
        super(context, new ZorseModel(context.bakeLayer(EnvironmentalModelLayers.ZORSE)), 0.75f);
        this.addLayer(new ZorseStripesRenderLayer((RenderLayerParent<Zorse, ZorseModel<Zorse>>)this));
        this.addLayer(new ZorseMarkingsLayer((RenderLayerParent<Zorse, ZorseModel<Zorse>>)this));
        this.addLayer(new ZorseArmorLayer((RenderLayerParent<Zorse, ZorseModel<Zorse>>)this, context.getModelSet()));
    }

    public ResourceLocation getTextureLocation(Zorse zorse) {
        return (ResourceLocation)HorseRenderer.LOCATION_BY_VARIANT.get(zorse.getVariant());
    }
}

