/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.client.model.SlabfishModel;
import com.teamabnormals.environmental.client.resources.SlabfishSpriteUploader;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.slabfish.SlabfishBackpack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackRenderLayer<E extends Slabfish, M extends SlabfishModel<E>>
extends RenderLayer<E, M> {
    public BackpackRenderLayer(RenderLayerParent<E, M> entityRenderer) {
        super(entityRenderer);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn, E slabby, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((Slabfish)((Object)slabby)).hasBackpack()) {
            return;
        }
        VertexConsumer builder = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)SlabfishSpriteUploader.ATLAS_LOCATION));
        ((SlabfishModel)this.getParentModel()).sprite = SlabfishSpriteUploader.instance().getSprite(((SlabfishBackpack)((Slabfish)((Object)slabby)).getBackpack().get().value()).texture());
        ((SlabfishModel)this.getParentModel()).setupAnim(slabby, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ((SlabfishModel)this.getParentModel()).renderToBuffer(matrixStack, builder, packedLightIn, OverlayTexture.NO_OVERLAY);
    }
}

